/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.MeshAttributeIndicesEncodingObserver;
import dev.fileformat.drako.TraverserBase;

class EdgeBreakerTraverser<TCornerTable extends ICornerTable>
extends TraverserBase<TCornerTable> {
    private MeshAttributeIndicesEncodingObserver<TCornerTable> traversalObserver;
    private IntList cornerTraversalStack;

    public EdgeBreakerTraverser(TCornerTable corner_table, MeshAttributeIndicesEncodingObserver<TCornerTable> observer) {
        this.$initFields$();
        this.traversalObserver = observer;
        this.init(corner_table, observer);
    }

    public EdgeBreakerTraverser(MeshAttributeIndicesEncodingObserver<TCornerTable> traversalObserver) {
        this.$initFields$();
        this.corner_table_ = traversalObserver.getCornerTable();
        this.traversalObserver = traversalObserver;
        this.init(this.corner_table_, traversalObserver);
    }

    @Override
    public void traverseFromCorner(int cornerId) {
        this.cornerTraversalStack.clear();
        this.cornerTraversalStack.add(cornerId);
        int nextVert = this.corner_table_.vertex(this.corner_table_.next(cornerId));
        int prevVert = this.corner_table_.vertex(this.corner_table_.previous(cornerId));
        if (!this.isVertexVisited(nextVert)) {
            this.markVertexVisited(nextVert);
            this.traversalObserver.onNewVertexVisited(nextVert, this.corner_table_.next(cornerId));
        }
        if (!this.isVertexVisited(prevVert)) {
            this.markVertexVisited(prevVert);
            this.traversalObserver.onNewVertexVisited(prevVert, this.corner_table_.previous(cornerId));
        }
        block0: while (this.cornerTraversalStack.getCount() > 0) {
            int leftCornerId;
            int rightCornerId;
            cornerId = this.cornerTraversalStack.get(this.cornerTraversalStack.getCount() - 1);
            int faceId = cornerId / 3;
            if (cornerId < 0 || this.isFaceVisited(faceId)) {
                this.cornerTraversalStack.removeAt(this.cornerTraversalStack.getCount() - 1);
                continue;
            }
            while (true) {
                int leftFaceId;
                faceId = cornerId / 3;
                this.markFaceVisited(faceId);
                this.traversalObserver.onNewFaceVisited(faceId);
                int vertId = this.corner_table_.vertex(cornerId);
                boolean onBoundary = this.corner_table_.isOnBoundary(vertId);
                if (!this.isVertexVisited(vertId)) {
                    this.markVertexVisited(vertId);
                    this.traversalObserver.onNewVertexVisited(vertId, cornerId);
                    if (!onBoundary) {
                        cornerId = this.corner_table_.getRightCorner(cornerId);
                        continue;
                    }
                }
                rightCornerId = this.corner_table_.getRightCorner(cornerId);
                leftCornerId = this.corner_table_.getLeftCorner(cornerId);
                int rightFaceId = rightCornerId < 0 ? -1 : rightCornerId / 3;
                int n = leftFaceId = leftCornerId < 0 ? -1 : leftCornerId / 3;
                if (this.isFaceVisited(rightFaceId)) {
                    if (this.isFaceVisited(leftFaceId)) {
                        this.cornerTraversalStack.removeAt(this.cornerTraversalStack.getCount() - 1);
                        continue block0;
                    }
                    cornerId = leftCornerId;
                    continue;
                }
                if (!this.isFaceVisited(leftFaceId)) break;
                cornerId = rightCornerId;
            }
            this.cornerTraversalStack.set(this.cornerTraversalStack.getCount() - 1, leftCornerId);
            this.cornerTraversalStack.add(rightCornerId);
        }
    }

    @Override
    public void onTraversalStart() {
    }

    @Override
    public void onTraversalEnd() {
    }

    private void $initFields$() {
        try {
            this.cornerTraversalStack = new IntList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

