/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.CornerTable;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.MeshAttributeIndicesEncodingObserver;
import dev.fileformat.drako.TraverserBase;

class DepthFirstTraverser
extends TraverserBase<CornerTable> {
    private IntList corner_traversal_stack_;

    public DepthFirstTraverser(CornerTable cornerTable, MeshAttributeIndicesEncodingObserver<CornerTable> traversal_observer) {
        this.$initFields$();
        this.init(cornerTable, traversal_observer);
    }

    @Override
    public void traverseFromCorner(int corner_id) throws DrakoException {
        if (this.isCornerVisited(corner_id)) {
            return;
        }
        this.corner_traversal_stack_.clear();
        this.corner_traversal_stack_.add(corner_id);
        int next_vert = ((CornerTable)this.corner_table_).vertex(((CornerTable)this.corner_table_).next(corner_id));
        int prev_vert = ((CornerTable)this.corner_table_).vertex(((CornerTable)this.corner_table_).previous(corner_id));
        if (next_vert == -1 || prev_vert == -1) {
            throw DracoUtils.failed();
        }
        if (!this.isVertexVisited(next_vert)) {
            this.markVertexVisited(next_vert);
            this.traversal_observer_.onNewVertexVisited(next_vert, ((CornerTable)this.corner_table_).next(corner_id));
        }
        if (!this.isVertexVisited(prev_vert)) {
            this.markVertexVisited(prev_vert);
            this.traversal_observer_.onNewVertexVisited(prev_vert, ((CornerTable)this.corner_table_).previous(corner_id));
        }
        block0: while (this.corner_traversal_stack_.getCount() > 0) {
            int left_corner_id;
            int right_corner_id;
            corner_id = this.corner_traversal_stack_.get(this.corner_traversal_stack_.getCount() - 1);
            int face_id = corner_id / 3;
            if (corner_id == -1 || this.isFaceVisited(face_id)) {
                this.corner_traversal_stack_.removeAt(this.corner_traversal_stack_.getCount() - 1);
                continue;
            }
            while (true) {
                int left_face_id;
                this.markFaceVisited(face_id);
                this.traversal_observer_.onNewFaceVisited(face_id);
                int vert_id = ((CornerTable)this.corner_table_).vertex(corner_id);
                if (vert_id == -1) {
                    throw DracoUtils.failed();
                }
                if (!this.isVertexVisited(vert_id)) {
                    boolean on_boundary = ((CornerTable)this.corner_table_).isOnBoundary(vert_id);
                    this.markVertexVisited(vert_id);
                    this.traversal_observer_.onNewVertexVisited(vert_id, corner_id);
                    if (!on_boundary) {
                        corner_id = ((CornerTable)this.corner_table_).getRightCorner(corner_id);
                        face_id = corner_id / 3;
                        continue;
                    }
                }
                right_corner_id = ((CornerTable)this.corner_table_).getRightCorner(corner_id);
                left_corner_id = ((CornerTable)this.corner_table_).getLeftCorner(corner_id);
                int right_face_id = right_corner_id == -1 ? -1 : right_corner_id / 3;
                int n = left_face_id = left_corner_id == -1 ? -1 : left_corner_id / 3;
                if (this.isFaceVisited(right_face_id)) {
                    if (this.isFaceVisited(left_face_id)) {
                        this.corner_traversal_stack_.removeAt(this.corner_traversal_stack_.getCount() - 1);
                        continue block0;
                    }
                    corner_id = left_corner_id;
                    face_id = left_face_id;
                    continue;
                }
                if (!this.isFaceVisited(left_face_id)) break;
                corner_id = right_corner_id;
                face_id = right_face_id;
            }
            this.corner_traversal_stack_.set(this.corner_traversal_stack_.getCount() - 1, left_corner_id);
            this.corner_traversal_stack_.add(right_corner_id);
        }
    }

    @Override
    public void onTraversalStart() {
    }

    @Override
    public void onTraversalEnd() {
    }

    private void $initFields$() {
        try {
            this.corner_traversal_stack_ = new IntList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

