/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.ICornerTable;

class CornerTableTraversalProcessor<TCornerTable extends ICornerTable> {
    private TCornerTable cornerTable;
    private boolean[] isFaceVisited;
    private boolean[] isVertexVisited;

    public CornerTableTraversalProcessor(TCornerTable cornerTable) {
        this.cornerTable = cornerTable;
        this.isFaceVisited = new boolean[((ICornerTable)cornerTable).getNumFaces()];
        this.resetVertexData();
    }

    public boolean isFaceVisited(int faceId) {
        if (faceId < 0) {
            return true;
        }
        return this.isFaceVisited[faceId];
    }

    public void markFaceVisited(int faceId) {
        this.isFaceVisited[faceId] = true;
    }

    public boolean isVertexVisited(int vertId) {
        return this.isVertexVisited[vertId];
    }

    public void markVertexVisited(int vertId) {
        this.isVertexVisited[vertId] = true;
    }

    protected void resetVertexData() {
        this.initVertexData(((ICornerTable)this.cornerTable).getNumVertices());
    }

    protected void initVertexData(int numVerts) {
        this.isVertexVisited = new boolean[numVerts];
    }

    public TCornerTable getCornerTable() {
        return this.cornerTable;
    }
}

