/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

@Internal
class Charsets {
    public static final int BOM_UTF_8 = 19;
    public static final int BOM_UTF_16BE = 34;
    public static final int BOM_UTF_16LE = 50;
    public static final int BOM_UTF_32BE = 68;
    public static final int BOM_UTF_32LE = 84;
    public static final int BOM_UNSUPPORTED = 0;
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset ASCII = Charset.forName("US-ASCII");

    Charsets() {
    }

    public static int parseByteOrderMark(byte[] arr, int start, int len) {
        int c;
        int b;
        int a;
        int bom;
        int size = Math.min(len, arr.length - start);
        if (size >= 4) {
            long a2 = 0xFF & arr[start + 0];
            long b2 = 0xFF & arr[start + 1];
            long c2 = 0xFF & arr[start + 2];
            long d = 0xFF & arr[start + 3];
            long bom2 = a2 << 24 | b2 << 16 | c2 << 8 | d;
            if (bom2 == 65279L) {
                return 68;
            }
            if (bom2 == -131072L) {
                return 84;
            }
        }
        if (size >= 3 && (bom = (a = 0xFF & arr[start + 0]) << 16 | (b = 0xFF & arr[start + 1]) << 8 | (c = 0xFF & arr[start + 2])) == 0xEFBBBF) {
            return 19;
        }
        if (size >= 2) {
            a = 0xFF & arr[start + 0];
            b = 0xFF & arr[start + 1];
            int bom3 = a << 8 | b;
            if (bom3 == 65279) {
                return 34;
            }
            if (bom3 == 65534) {
                return 50;
            }
        }
        return 0;
    }

    public static int getBOMLength(int bom) {
        return bom & 0xF;
    }

    public static Charset charsetFromBOM(int bom) {
        switch (bom) {
            case 19: {
                return UTF_8;
            }
            case 34: {
                return UTF_16BE;
            }
            case 50: {
                return UTF_16LE;
            }
        }
        return ASCII;
    }

    public static int getBytes(Charset charset, String str, int charIdx, int charCount, byte[] buffer, int bufferIdx) {
        CharBuffer cb = CharBuffer.wrap(str, charIdx, charCount + charIdx);
        return Charsets.getBytesImpl(charset, cb, buffer, bufferIdx);
    }

    public static int getBytes(Charset charset, char[] str, int charIdx, int charCount, byte[] buffer, int bufferIdx) {
        CharBuffer cb = CharBuffer.wrap(str, charIdx, charCount + charIdx);
        return Charsets.getBytesImpl(charset, cb, buffer, bufferIdx);
    }

    private static int getBytesImpl(Charset charset, CharBuffer chars, byte[] buffer, int bufferIdx) {
        ByteBuffer bytes = charset.encode(chars);
        int size = Math.min(bytes.limit(), buffer.length - bufferIdx);
        if (size > 0) {
            bytes.get(buffer, bufferIdx, size);
        }
        return size;
    }
}

