/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributeTransform;
import dev.fileformat.drako.AttributeTransformData;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.FloatSpan;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.Quantizer;

class AttributeQuantizationTransform
extends AttributeTransform {
    public int quantization_bits_;
    public float[] min_values_;
    public float range_;

    @Override
    protected int getTransformedDataType(PointAttribute attribute) {
        return 6;
    }

    @Override
    protected int getTransformedNumComponents(PointAttribute attribute) {
        return attribute.getComponentsCount();
    }

    @Override
    public void copyToAttributeTransformData(AttributeTransformData out_data) {
        out_data.transformType = 1;
        out_data.appendValue(this.quantization_bits_);
        for (int i = 0; i < this.min_values_.length; ++i) {
            out_data.appendValue(this.min_values_[i]);
        }
        out_data.appendValue(this.range_);
    }

    public void transformAttribute(PointAttribute attribute, int[] point_ids, PointAttribute target_attribute) {
        if (point_ids.length == 0) {
            this.generatePortableAttribute(attribute, target_attribute.getNumUniqueEntries(), target_attribute);
        } else {
            this.generatePortableAttribute(attribute, point_ids, target_attribute.getNumUniqueEntries(), target_attribute);
        }
    }

    public void setParameters(int quantization_bits, float[] min_values, int num_components, float range) {
        this.quantization_bits_ = quantization_bits;
        this.min_values_ = (float[])min_values.clone();
        this.range_ = range;
    }

    public void computeParameters(PointAttribute attribute, int quantization_bits) throws DrakoException {
        if (this.quantization_bits_ != -1) {
            throw DracoUtils.failed();
        }
        this.quantization_bits_ = quantization_bits;
        int num_components = attribute.getComponentsCount();
        this.range_ = 0.0f;
        this.min_values_ = new float[num_components];
        float[] max_values = new float[num_components];
        float[] att_val = new float[num_components];
        attribute.getValue(0, att_val);
        attribute.getValue(0, this.min_values_);
        attribute.getValue(0, max_values);
        for (int i = 1; i < attribute.getNumUniqueEntries(); ++i) {
            attribute.getValue(i, att_val);
            for (int c = 0; c < num_components; ++c) {
                if (this.min_values_[c] > att_val[c]) {
                    this.min_values_[c] = att_val[c];
                }
                if (!(max_values[c] < att_val[c])) continue;
                max_values[c] = att_val[c];
            }
        }
        for (int c = 0; c < num_components; ++c) {
            float dif = max_values[c] - this.min_values_[c];
            if (!(dif > this.range_)) continue;
            this.range_ = dif;
        }
        if (DracoUtils.isZero(this.range_)) {
            this.range_ = 1.0f;
        }
    }

    public void encodeParameters(EncoderBuffer encoder_buffer) throws DrakoException {
        if (this.quantization_bits_ == -1) {
            throw DracoUtils.failed();
        }
        encoder_buffer.encode(this.min_values_);
        encoder_buffer.encode(this.range_);
        encoder_buffer.encode((byte)this.quantization_bits_);
    }

    public void generatePortableAttribute(PointAttribute attribute, int num_points, PointAttribute target_attribute) {
        int num_entries = num_points;
        int num_components = attribute.getComponentsCount();
        IntSpan portable_attribute_data = target_attribute.getAddress(0).asIntSpan();
        int max_quantized_value = (1 << this.quantization_bits_) - 1;
        Quantizer quantizer = new Quantizer(this.range_, max_quantized_value);
        int dst_index = 0;
        float[] att_val = new float[num_components];
        for (int i = 0; i < num_points; ++i) {
            int att_val_id = attribute.mappedIndex(i);
            attribute.getValue(att_val_id, att_val);
            for (int c = 0; c < num_components; ++c) {
                float value = att_val[c] - this.min_values_[c];
                int q_val = quantizer.quantizeFloat(value);
                portable_attribute_data.put(dst_index++, q_val);
            }
        }
    }

    public void generatePortableAttribute(PointAttribute attribute, int[] point_ids, int num_points, PointAttribute target_attribute) {
        int num_entries = point_ids.length;
        int num_components = attribute.getComponentsCount();
        IntSpan portable_attribute_data = target_attribute.getAddress(0).asIntSpan();
        int max_quantized_value = (1 << this.quantization_bits_) - 1;
        Quantizer quantizer = new Quantizer(this.range_, max_quantized_value);
        int dst_index = 0;
        FloatSpan att_val = FloatSpan.wrap(new float[num_components]);
        for (int i = 0; i < point_ids.length; ++i) {
            int att_val_id = attribute.mappedIndex(point_ids[i]);
            attribute.getValue(att_val_id, att_val);
            for (int c = 0; c < num_components; ++c) {
                float value = att_val.get(c) - this.min_values_[c];
                int q_val = quantizer.quantizeFloat(value);
                portable_attribute_data.put(dst_index++, q_val);
            }
        }
    }

    public AttributeQuantizationTransform() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.quantization_bits_ = -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

