/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.volley.Response;
import com.android.volley.cache.SimpleImageLoader;
import com.android.volley.error.VolleyError;
import com.android.volley.misc.Utils;
import com.android.volley.toolbox.ImageLoader;

public class NetworkImageView
extends ImageView {
    private final int[] attrsArray = new int[]{0x1010119};
    private static final ColorDrawable transparentDrawable = new ColorDrawable(17170445);
    private static final int HALF_FADE_IN_TIME = 100;
    protected String mUrl;
    int mDefaultImageId;
    int mErrorImageId;
    protected ImageLoader mImageLoader;
    protected ImageLoader.ImageContainer mImageContainer;
    private boolean mFadeInImage = true;
    private int mMaxImageHeight = 0;
    private int mMaxImageWidth = 0;
    private Response.Listener<Bitmap> mListener;

    public NetworkImageView(Context context) {
        this(context, null);
    }

    public NetworkImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NetworkImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, this.attrsArray);
        this.setDefaultImageResId(a.getResourceId(0, 0));
        a.recycle();
    }

    public void setImageUrl(String url, ImageLoader imageLoader) {
        this.mUrl = url;
        this.mImageLoader = imageLoader;
        this.loadImageIfNecessary(false);
    }

    public void setResetImageUrl(String url, ImageLoader imageLoader) {
        this.mImageContainer = null;
        this.mUrl = url;
        this.mImageLoader = imageLoader;
        this.loadImageIfNecessary(false);
    }

    public void setDefaultImageResId(int defaultImage) {
        this.mDefaultImageId = defaultImage;
    }

    public void setErrorImageResId(int errorImage) {
        this.mErrorImageId = errorImage;
    }

    public void setMaxImageSize(int maxImageWidth, int maxImageHeight) {
        this.mMaxImageWidth = maxImageWidth;
        this.mMaxImageHeight = maxImageHeight;
    }

    public void setMaxImageSize(int maxImageSize) {
        this.setMaxImageSize(maxImageSize, maxImageSize);
    }

    public void setFadeInImage(boolean fadeInImage) {
        this.mFadeInImage = fadeInImage;
    }

    public void setImageListener(Response.Listener<Bitmap> listener) {
        this.mListener = listener;
    }

    public Response.Listener<Bitmap> getImageListener() {
        return this.mListener;
    }

    void loadImageIfNecessary(final boolean isInLayoutPass) {
        ImageLoader.ImageContainer newContainer;
        boolean isFullyWrapContent;
        int width = this.getWidth();
        int height = this.getHeight();
        ImageView.ScaleType scaleType = this.getScaleType();
        boolean wrapWidth = false;
        boolean wrapHeight = false;
        if (this.getLayoutParams() != null) {
            wrapWidth = this.getLayoutParams().width == -2;
            wrapHeight = this.getLayoutParams().height == -2;
        }
        boolean bl = isFullyWrapContent = wrapWidth && wrapHeight;
        if (width == 0 && height == 0 && !isFullyWrapContent) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageContainer != null) {
                this.mImageContainer.cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        if (this.mImageContainer != null && this.mImageContainer.getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) {
                return;
            }
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        int maxWidth = 0;
        int maxHeight = 0;
        if (this.mImageLoader instanceof SimpleImageLoader) {
            SimpleImageLoader loader = (SimpleImageLoader)this.mImageLoader;
            maxWidth = this.mMaxImageWidth == 0 ? loader.getMaxImageWidth() : this.mMaxImageWidth;
            maxHeight = this.mMaxImageHeight == 0 ? loader.getMaxImageHeight() : this.mMaxImageHeight;
        } else {
            maxWidth = wrapWidth ? 0 : width;
            maxHeight = wrapHeight ? 0 : height;
        }
        this.mImageContainer = newContainer = this.mImageLoader.get(this.mUrl, new ImageLoader.ImageListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (NetworkImageView.this.mErrorImageId != 0) {
                    NetworkImageView.this.setImageResource(NetworkImageView.this.mErrorImageId);
                }
            }

            @Override
            public void onResponse(final ImageLoader.ImageContainer response, boolean isImmediate) {
                if (isImmediate && isInLayoutPass) {
                    NetworkImageView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            this.onResponse(response, false);
                        }
                    });
                    return;
                }
                if (response.getBitmap() != null) {
                    NetworkImageView.this.setAnimateImageBitmap(response.getBitmap(), NetworkImageView.this.mFadeInImage);
                    if (null != NetworkImageView.this.mListener) {
                        NetworkImageView.this.mListener.onResponse(response.getBitmap());
                    }
                } else if (NetworkImageView.this.mDefaultImageId != 0) {
                    NetworkImageView.this.setImageResource(NetworkImageView.this.mDefaultImageId);
                }
            }
        }, maxWidth, maxHeight, scaleType);
    }

    @SuppressLint(value={"NewApi"})
    private void setAnimateImageBitmap(final Bitmap bitmap, boolean fadeIn) {
        if (fadeIn && Utils.hasHoneycombMR1()) {
            this.animate().scaleY(0.95f).scaleX(0.95f).alpha(0.0f).setDuration(this.getDrawable() == null ? 0L : 100L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    NetworkImageView.this.setImageBitmap(bitmap);
                    NetworkImageView.this.animate().alpha(1.0f).scaleY(1.0f).scaleX(1.0f).setDuration(100L).setListener(null);
                }
            });
        } else if (fadeIn) {
            Object initialDrawable = this.getDrawable() != null ? this.getDrawable() : transparentDrawable;
            BitmapDrawable bitmapDrawable = new BitmapDrawable(this.getResources(), bitmap);
            TransitionDrawable td = new TransitionDrawable(new Drawable[]{initialDrawable, bitmapDrawable});
            this.setImageDrawable((Drawable)td);
            td.startTransition(200);
        } else {
            this.setImageBitmap(bitmap);
        }
    }

    protected void setDefaultImageOrNull() {
        if (this.mDefaultImageId != 0) {
            this.setImageResource(this.mDefaultImageId);
        } else {
            this.setImageBitmap(null);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mImageLoader != null) {
            this.loadImageIfNecessary(true);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mImageContainer != null) {
            this.mImageContainer.cancelRequest();
            this.setImageBitmap(null);
            this.mImageContainer = null;
        }
        super.onDetachedFromWindow();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }
}

