/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox.multipart;

import com.android.volley.misc.MultipartUtils;
import com.android.volley.toolbox.multipart.Boundary;
import com.android.volley.toolbox.multipart.Part;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.EncodingUtils;

abstract class BasePart
implements Part {
    protected IHeadersProvider headersProvider;
    private byte[] header;

    BasePart() {
    }

    protected byte[] getHeader(Boundary boundary) {
        if (this.header == null) {
            this.header = this.generateHeader(boundary);
        }
        return this.header;
    }

    private byte[] generateHeader(Boundary boundary) {
        if (this.headersProvider == null) {
            throw new RuntimeException("Uninitialized headersProvider");
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(256);
        BasePart.append(buf, boundary.getStartingBoundary());
        BasePart.append(buf, this.headersProvider.getContentDisposition());
        BasePart.append(buf, MultipartUtils.CRLF_BYTES);
        BasePart.append(buf, this.headersProvider.getContentType());
        BasePart.append(buf, MultipartUtils.CRLF_BYTES);
        BasePart.append(buf, MultipartUtils.CRLF_BYTES);
        return buf.toByteArray();
    }

    private static void append(ByteArrayBuffer buf, String data) {
        BasePart.append(buf, EncodingUtils.getAsciiBytes((String)data));
    }

    private static void append(ByteArrayBuffer buf, byte[] data) {
        buf.append(data, 0, data.length);
    }

    protected static interface IHeadersProvider {
        public String getContentDisposition();

        public String getContentType();

        public String getContentTransferEncoding();
    }
}

