/*
 * Decompiled with CFR 0.152.
 */
package dev.doubledot.doki.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.FontRes;
import androidx.appcompat.widget.AppCompatTextView;
import dev.doubledot.doki.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\u0014J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0014J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010(\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010)\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078G@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/doubledot/doki/views/BaselineGridTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "FOUR_DIP", "", "extraBottomPadding", "extraTopPadding", "<set-?>", "fontResId", "getFontResId", "()I", "lineHeightHint", "lineHeightMultiplierHint", "maxLinesByHeight", "", "checkMaxLines", "", "height", "heightMode", "computeLineHeight", "ensureBaselineOnGrid", "ensureHeightGridAligned", "getCompoundPaddingBottom", "getCompoundPaddingTop", "getLineHeightHint", "getLineHeightMultiplierHint", "getMaxLinesByHeight", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "parseTextAttrs", "a", "Landroid/content/res/TypedArray;", "setLineHeightHint", "setLineHeightMultiplierHint", "setMaxLinesByHeight", "library_release"})
public final class BaselineGridTextView
extends AppCompatTextView {
    private final float FOUR_DIP;
    private float lineHeightMultiplierHint;
    private float lineHeightHint;
    private boolean maxLinesByHeight;
    private int extraTopPadding;
    private int extraBottomPadding;
    @FontRes
    private int fontResId;

    @FontRes
    public final int getFontResId() {
        return this.fontResId;
    }

    public final float getLineHeightMultiplierHint() {
        return this.lineHeightMultiplierHint;
    }

    public final void setLineHeightMultiplierHint(float lineHeightMultiplierHint) {
        this.lineHeightMultiplierHint = lineHeightMultiplierHint;
        this.computeLineHeight();
    }

    public final float getLineHeightHint() {
        return this.lineHeightHint;
    }

    public final void setLineHeightHint(float lineHeightHint) {
        this.lineHeightHint = lineHeightHint;
        this.computeLineHeight();
    }

    public final boolean getMaxLinesByHeight() {
        return this.maxLinesByHeight;
    }

    public final void setMaxLinesByHeight(boolean maxLinesByHeight) {
        this.maxLinesByHeight = maxLinesByHeight;
        this.requestLayout();
    }

    public int getCompoundPaddingTop() {
        return super.getCompoundPaddingTop() + this.extraTopPadding;
    }

    public int getCompoundPaddingBottom() {
        return super.getCompoundPaddingBottom() + this.extraBottomPadding;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.extraTopPadding = 0;
        this.extraBottomPadding = 0;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.getMeasuredHeight();
        height += this.ensureBaselineOnGrid();
        height += this.ensureHeightGridAligned(height);
        this.setMeasuredDimension(this.getMeasuredWidth(), height);
        this.checkMaxLines(height, View.MeasureSpec.getMode((int)heightMeasureSpec));
    }

    private final void parseTextAttrs(TypedArray a) {
        if (a.hasValue(R.styleable.BaselineGridTextView_lineHeightMultiplierHint)) {
            this.lineHeightMultiplierHint = a.getFloat(R.styleable.BaselineGridTextView_lineHeightMultiplierHint, 1.0f);
        }
        if (a.hasValue(R.styleable.BaselineGridTextView_lineHeightHint)) {
            this.lineHeightHint = a.getDimensionPixelSize(R.styleable.BaselineGridTextView_lineHeightHint, 0);
        }
        if (a.hasValue(R.styleable.BaselineGridTextView_android_fontFamily)) {
            this.fontResId = a.getResourceId(R.styleable.BaselineGridTextView_android_fontFamily, 0);
        }
    }

    private final void computeLineHeight() {
        TextPaint textPaint = this.getPaint();
        Intrinsics.checkExpressionValueIsNotNull((Object)textPaint, (String)"paint");
        Paint.FontMetrics fm = textPaint.getFontMetrics();
        float fontHeight = Math.abs(fm.ascent - fm.descent) + fm.leading;
        float desiredLineHeight = this.lineHeightHint > 0.0f ? this.lineHeightHint : this.lineHeightMultiplierHint * fontHeight;
        int baselineAlignedLineHeight = (int)(this.FOUR_DIP * (float)Math.ceil(desiredLineHeight / this.FOUR_DIP) + 0.5f);
        this.setLineSpacing((float)baselineAlignedLineHeight - fontHeight, 1.0f);
    }

    private final int ensureBaselineOnGrid() {
        float baseline = this.getBaseline();
        float gridAlign = baseline % this.FOUR_DIP;
        if (gridAlign != 0.0f) {
            this.extraTopPadding = (int)((double)this.FOUR_DIP - Math.ceil(gridAlign));
        }
        return this.extraTopPadding;
    }

    private final int ensureHeightGridAligned(int height) {
        float gridOverhang = (float)height % this.FOUR_DIP;
        if (gridOverhang != 0.0f) {
            this.extraBottomPadding = (int)((double)this.FOUR_DIP - Math.ceil(gridOverhang));
        }
        return this.extraBottomPadding;
    }

    private final void checkMaxLines(int height, int heightMode) {
        if (!this.maxLinesByHeight || heightMode != 0x40000000) {
            return;
        }
        int textHeight = height - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
        int completeLines = (int)Math.floor(textHeight / this.getLineHeight());
        this.setMaxLines(completeLines);
    }

    @JvmOverloads
    public BaselineGridTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.lineHeightMultiplierHint = 1.0f;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BaselineGridTextView, defStyleAttr, 0);
        if (a.hasValue(R.styleable.BaselineGridTextView_android_textAppearance)) {
            TypedArray ta;
            int textAppearanceId = a.getResourceId(R.styleable.BaselineGridTextView_android_textAppearance, 16973886);
            TypedArray typedArray = ta = context.obtainStyledAttributes(textAppearanceId, R.styleable.BaselineGridTextView);
            Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"ta");
            this.parseTextAttrs(typedArray);
            ta.recycle();
        }
        TypedArray typedArray = a;
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"a");
        this.parseTextAttrs(typedArray);
        this.maxLinesByHeight = a.getBoolean(R.styleable.BaselineGridTextView_maxLinesByHeight, false);
        a.recycle();
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        this.FOUR_DIP = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)resources.getDisplayMetrics());
        this.computeLineHeight();
    }

    @JvmOverloads
    public /* synthetic */ BaselineGridTextView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 16842884;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BaselineGridTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BaselineGridTextView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

