/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.blockchain;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.WalletUtils;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.http.HttpService;
import org.web3j.utils.Convert;

public class Transfer {
    private static final String BLOCKCHAIN_SERVER_URL = "http://127.0.0.1:7545";
    private static final String ZIEL_JSON_ADDRSSE = "0x1486df323a85999fb6a540492dc8725c8ecdfb9b";
    private static final String ZIEL_ADDRESSE = "0x1486df323a85999fb6a540492dc8725c8ecdfb9b";
    private static final String WALLET_PASSWORD = "password";
    private static final Logger LOG = LogManager.getLogger(Transfer.class);

    public static void main(String[] args) throws Exception {
        Transfer transfer = new Transfer();
        Web3j web3 = transfer.connect(BLOCKCHAIN_SERVER_URL);
        LOG.info("Ziel Addresse");
        transfer.printBalance(web3, "0x1486df323a85999fb6a540492dc8725c8ecdfb9b");
        Credentials credentials = WalletUtils.loadCredentials((String)WALLET_PASSWORD, (String)"UTC--2021-09-25T15-09-47.203000000Z--8e031f1c47537910fe104936dcd0f77f8a97c6f1.json");
        LOG.info("Von Wallet Adresse");
        transfer.printBalance(web3, credentials.getAddress());
        double ueberweiseBetragInEther = 0.015;
        transfer.send(web3, credentials, "0x1486df323a85999fb6a540492dc8725c8ecdfb9b", ueberweiseBetragInEther);
    }

    private void send(Web3j web3, Credentials credentials, String zielAdresse, double ether) throws Exception {
        LOG.info("Send " + ether + " Ether  = " + Convert.toWei((BigDecimal)BigDecimal.valueOf(ether), (Convert.Unit)Convert.Unit.ETHER) + " WEI");
        TransactionReceipt transactionReceipt = (TransactionReceipt)org.web3j.tx.Transfer.sendFunds((Web3j)web3, (Credentials)credentials, (String)zielAdresse, (BigDecimal)BigDecimal.valueOf(ether), (Convert.Unit)Convert.Unit.ETHER).send();
        LOG.info("Betrag von Adresse: " + transactionReceipt.getFrom());
        LOG.info("In Block Nummer   : " + transactionReceipt.getBlockNumber());
        this.printBalance(web3, zielAdresse);
    }

    private Web3j connect(String blockchainServerUrl) {
        Web3j web3 = Web3j.build((Web3jService)new HttpService(BLOCKCHAIN_SERVER_URL));
        LOG.info("OK, verbunden mit Blockchain " + blockchainServerUrl + " ...");
        return web3;
    }

    private void printBalance(Web3j web3, String addresse) throws IOException, InterruptedException, ExecutionException {
        Web3ClientVersion clientVersion = null;
        try {
            clientVersion = (Web3ClientVersion)web3.web3ClientVersion().send();
        }
        catch (ConnectException e) {
            LOG.error("Die Blockchain ist nicht erreichbar. Starten vergessen? Oder URL oder Port falsch?");
            throw e;
        }
        LOG.debug("Client Version: " + clientVersion.getWeb3ClientVersion());
        EthGasPrice gasPrice = (EthGasPrice)web3.ethGasPrice().send();
        LOG.debug("Default Gas Preis: " + gasPrice.getGasPrice());
        LOG.info("Addresse:           " + addresse);
        LOG.info("Bestand:            " + Convert.fromWei((String)((EthGetBalance)web3.ethGetBalance(addresse, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance().toString(), (Convert.Unit)Convert.Unit.ETHER) + " Ether =  " + Convert.fromWei((String)((EthGetBalance)web3.ethGetBalance(addresse, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance().toString(), (Convert.Unit)Convert.Unit.GWEI) + " GWEI");
    }
}

