/*
 * Decompiled with CFR 0.152.
 */
package de.wenzlaff.blockchain;

import de.wenzlaff.blockchain.be.Block;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Blockchain {
    private static final Logger LOG = LogManager.getLogger(Blockchain.class);
    private List<Block> chain = new ArrayList<Block>();

    public boolean add(Block block) {
        return this.chain.add(block);
    }

    public boolean checkBlockchain() {
        boolean ergebnis = this.validate();
        if (ergebnis) {
            LOG.info("Die Blockchain ist g\u00fcltig.");
        } else {
            LOG.error("Die Blockchain ist gehackt worden und ung\u00fcltig.");
        }
        return ergebnis;
    }

    public void printBlockchain() {
        this.chain.forEach(b -> LOG.info(b));
    }

    public int getPreviousHash() {
        return this.chain.get(this.getAnzahlBlocks() - 1).getHash();
    }

    public Block get(int i) {
        return this.chain.get(i);
    }

    public void remove(int i) {
        this.chain.remove(i);
    }

    public void add(int i, Block block) {
        this.chain.add(i, block);
    }

    public int getAnzahlBlocks() {
        return this.chain.size();
    }

    public boolean validate() {
        boolean result = true;
        Block lastBlock = null;
        for (int i = this.getAnzahlBlocks() - 1; i >= 0; --i) {
            if (lastBlock == null) {
                lastBlock = this.get(i);
                continue;
            }
            Block current = this.get(i);
            if (lastBlock.getPreviousHash() != current.getHash()) {
                result = false;
                break;
            }
            lastBlock = current;
        }
        return result;
    }
}

