/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitchangelog.perform;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.util.ArrayList;
import java.util.logging.Level;
import org.jenkinsci.plugins.gitchangelog.GitChangelogLogger;
import org.jenkinsci.plugins.gitchangelog.config.CredentialsHelper;
import org.jenkinsci.plugins.gitchangelog.config.CustomIssue;
import org.jenkinsci.plugins.gitchangelog.config.GitChangelogConfig;
import org.jenkinsci.plugins.gitchangelog.perform.GitChangelogLeftsideBuildDecorator;
import org.jenkinsci.plugins.gitchangelog.perform.GitChangelogSummaryDecorator;
import org.jenkinsci.plugins.gitchangelog.perform.RemoteCallable;
import org.jenkinsci.plugins.gitchangelog.perform.RemoteResult;

public class GitChangelogPerformer {
    public static void performerPerform(GitChangelogConfig configUnexpanded, Run<?, ?> build, TaskListener listener, FilePath workspace) {
        try {
            EnvVars env = build.getEnvironment(listener);
            GitChangelogConfig config = GitChangelogPerformer.expand(configUnexpanded, env);
            listener.getLogger().println("---");
            listener.getLogger().println("--- Git Changelog ---");
            listener.getLogger().println("---");
            GitChangelogPerformer.setApiTokenCredentials(config, listener);
            RemoteCallable remoteTask = new RemoteCallable(workspace.getRemote(), config);
            RemoteResult remoteResult = (RemoteResult)workspace.act((Callable)remoteTask);
            if (!Strings.isNullOrEmpty((String)remoteResult.getLeftSideTitle())) {
                build.addAction((Action)new GitChangelogLeftsideBuildDecorator(remoteResult.getLeftSideTitle(), remoteResult.getLeftSideUrl()));
            }
            if (!Strings.isNullOrEmpty((String)remoteResult.getSummary())) {
                build.addAction((Action)new GitChangelogSummaryDecorator(remoteResult.getSummary()));
            }
            GitChangelogLogger.doLog(listener, Level.INFO, remoteResult.getLog());
        }
        catch (Exception e) {
            GitChangelogLogger.doLog(listener, Level.SEVERE, e.getMessage(), e);
            return;
        }
    }

    private static void setApiTokenCredentials(GitChangelogConfig configExpanded, TaskListener listener) {
        String token;
        String getApiTokenCredentialsId;
        if (configExpanded.isUseGitHubApiTokenCredentials()) {
            getApiTokenCredentialsId = configExpanded.getGitHubApiTokenCredentialsId();
            token = (String)CredentialsHelper.findSecretString(getApiTokenCredentialsId).orNull();
            configExpanded.setGitHubToken(token);
        }
        if (configExpanded.isUseGitLabApiTokenCredentials()) {
            getApiTokenCredentialsId = configExpanded.getGitLabApiTokenCredentialsId();
            token = (String)CredentialsHelper.findSecretString(getApiTokenCredentialsId).orNull();
            configExpanded.setGitLabToken(token);
        }
        if (configExpanded.isUseJiraUsernamePasswordCredentialsId()) {
            getApiTokenCredentialsId = configExpanded.getJiraUsernamePasswordCredentialsId();
            token = (StandardUsernamePasswordCredentials)CredentialsHelper.findSecretUsernamePassword(getApiTokenCredentialsId).orNull();
            configExpanded.setJiraUsername(token.getUsername());
            configExpanded.setJiraPassword(token.getPassword().getPlainText());
        }
    }

    private static GitChangelogConfig expand(GitChangelogConfig config, EnvVars environment) {
        GitChangelogConfig c = new GitChangelogConfig();
        c.setUseConfigFile(config.isUseConfigFile());
        c.setConfigFile(environment.expand(config.getConfigFile()));
        c.setFromType(environment.expand(config.getFromType()));
        c.setFromReference(environment.expand(config.getFromReference()));
        c.setToType(environment.expand(config.getToType()));
        c.setToReference(environment.expand(config.getToReference()));
        c.setUseSubDirectory(config.isUseSubDirectory());
        c.setSubDirectory(environment.expand(config.getSubDirectory()));
        c.setDateFormat(environment.expand(config.getDateFormat()));
        c.setTimeZone(environment.expand(config.getTimeZone()));
        c.setIgnoreCommitsIfMessageMatches(environment.expand(config.getIgnoreCommitsIfMessageMatches()));
        c.setUseJira(config.isUseJira());
        c.setJiraServer(environment.expand(config.getJiraServer()));
        c.setJiraIssuePattern(environment.expand(config.getJiraIssuePattern()));
        c.setJiraUsername(environment.expand(config.getJiraUsername()));
        c.setJiraPassword(environment.expand(config.getJiraPassword()));
        c.setUseJiraUsernamePasswordCredentialsId(config.isUseJiraUsernamePasswordCredentialsId());
        c.setJiraUsernamePasswordCredentialsId(environment.expand(config.getJiraUsernamePasswordCredentialsId()));
        c.setUseGitHub(config.isUseGitHub());
        c.setGitHubApi(environment.expand(config.getGitHubApi()));
        c.setGitHubIssuePattern(environment.expand(config.getGitHubIssuePattern()));
        c.setGitHubToken(environment.expand(config.getGitHubToken()));
        c.setGitHubApiTokenCredentialsId(environment.expand(config.getGitHubApiTokenCredentialsId()));
        c.setUseGitHubApiTokenCredentials(config.isUseGitHubApiTokenCredentials());
        c.setUseGitLab(config.isUseGitLab());
        c.setGitLabServer(environment.expand(config.getGitLabServer()));
        c.setGitLabProjectName(environment.expand(config.getGitLabProjectName()));
        c.setGitLabToken(environment.expand(config.getGitLabToken()));
        c.setGitLabApiTokenCredentialsId(environment.expand(config.getGitLabApiTokenCredentialsId()));
        c.setUseGitLabApiTokenCredentials(config.isUseGitLabApiTokenCredentials());
        c.setNoIssueName(environment.expand(config.getNoIssueName()));
        c.setIgnoreCommitsWithoutIssue(config.isIgnoreCommitsWithoutIssue());
        c.setUntaggedName(environment.expand(config.getUntaggedName()));
        c.setUseReadableTagName(config.isUseReadableTagName());
        c.setReadableTagName(environment.expand(config.getReadableTagName()));
        c.setUseIgnoreTagsIfNameMatches(config.isUseIgnoreTagsIfNameMatches());
        c.setIgnoreTagsIfNameMatches(environment.expand(config.getIgnoreTagsIfNameMatches()));
        c.setUseMediaWiki(config.isUseMediaWiki());
        c.setMediaWikiUsername(environment.expand(config.getMediaWikiUsername()));
        c.setMediaWikiPassword(environment.expand(config.getMediaWikiPassword()));
        c.setMediaWikiTitle(environment.expand(config.getMediaWikiTitle()));
        c.setMediaWikiUrl(environment.expand(config.getMediaWikiUrl()));
        c.setMediaWikiUseTemplateFile(config.isMediaWikiUseTemplateFile());
        c.setMediaWikiTemplateFile(environment.expand(config.getMediaWikiTemplateFile()));
        c.setMediaWikiUseTemplateContent(config.isMediaWikiUseTemplateContent());
        c.setMediaWikiTemplateContent(environment.expand(config.getMediaWikiTemplateContent()));
        c.setUseFile(config.isUseFile());
        c.setFile(environment.expand(config.getFile()));
        c.setCreateFileUseTemplateFile(config.isCreateFileUseTemplateFile());
        c.setCreateFileTemplateFile(environment.expand(config.getCreateFileTemplateFile()));
        c.setCreateFileUseTemplateContent(config.isCreateFileUseTemplateContent());
        c.setCreateFileTemplateContent(environment.expand(config.getCreateFileTemplateContent()));
        c.setShowSummary(config.showSummary());
        c.setShowSummaryUseTemplateFile(config.isShowSummaryUseTemplateFile());
        c.setShowSummaryTemplateFile(environment.expand(config.getShowSummaryTemplateFile()));
        c.setShowSummaryUseTemplateContent(config.isShowSummaryUseTemplateContent());
        c.setShowSummaryTemplateContent(environment.expand(config.getShowSummaryTemplateContent()));
        ArrayList expandedCi = Lists.newArrayList();
        for (CustomIssue ci : config.getCustomIssues()) {
            expandedCi.add(new CustomIssue(environment.expand(ci.getName()), environment.expand(ci.getPattern()), environment.expand(ci.getLink()), environment.expand(ci.getTitle())));
        }
        c.setCustomIssues(expandedCi);
        return c;
    }
}

