/*
 * Decompiled with CFR 0.152.
 */
package de.wellnerbou.jenkins.gitchangelog.publish;

import de.wellnerbou.gitchangelog.processors.ChangelogProcessor;
import de.wellnerbou.gitchangelog.processors.basic.BasicChangelogProcessor;
import de.wellnerbou.jenkins.gitchangelog.publish.GitLogGenericPostPublishPerformer;
import de.wellnerbou.jenkins.gitchangelog.publish.GitLogGenericPostPublishPerformerBuilder;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitLogBasicChangelogPostPublisher
extends Publisher {
    public final String outputfile;
    public final String toRev;
    public final String fromRev;

    @DataBoundConstructor
    public GitLogBasicChangelogPostPublisher(String outputfile, String fromRev, String toRev) {
        this.outputfile = outputfile;
        this.fromRev = fromRev;
        this.toRev = toRev;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        GitLogGenericPostPublishPerformer performer = new GitLogGenericPostPublishPerformerBuilder().setChangelogProcessor(this.createChangelogProcessor()).withFromRev(this.fromRev).withToRev(this.toRev).writeTofile(this.outputfile).build();
        performer.perform(build, listener);
        return true;
    }

    private ChangelogProcessor createChangelogProcessor() {
        return new BasicChangelogProcessor();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Publish Git changelog";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

