/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitchangelog.perform;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkinsci.plugins.gitchangelog.config.CustomIssue;
import org.jenkinsci.plugins.gitchangelog.config.GitChangelogConfig;
import org.jenkinsci.plugins.gitchangelog.config.GitChangelogConfigHelper;
import org.jenkinsci.plugins.gitchangelog.perform.RemoteResult;
import org.jenkinsci.remoting.RoleChecker;
import se.bjurr.gitchangelog.api.GitChangelogApi;

public class RemoteCallable
extends MasterToSlaveCallable<RemoteResult, IOException>
implements Serializable {
    private static final long serialVersionUID = -2489061314794088231L;
    private final GitChangelogConfig config;
    private String path = "";
    private final String workspacePath;

    public RemoteCallable(String workspacePath, GitChangelogConfig config) {
        this.workspacePath = workspacePath;
        this.config = config;
    }

    public RemoteResult call() throws IOException {
        RemoteResult remoteResult = new RemoteResult();
        StringBuilder logString = new StringBuilder();
        this.path = this.workspacePath;
        if (this.config.isUseSubDirectory()) {
            this.path = this.workspacePath + "/" + this.config.getSubDirectory();
        }
        try {
            GitChangelogApi gitChangelogApiBuilder = GitChangelogApi.gitChangelogApiBuilder().withFromRepo(this.path);
            if (this.config.isUseConfigFile() && !Strings.isNullOrEmpty((String)this.config.getConfigFile())) {
                try {
                    gitChangelogApiBuilder.withSettings(Resources.getResource((String)(this.workspacePath + "/" + this.config.getConfigFile())).toURI().toURL());
                }
                catch (URISyntaxException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
            gitChangelogApiBuilder.withDateFormat(this.config.getDateFormat()).withIgnoreCommitsWithMessage(this.config.getIgnoreCommitsIfMessageMatches()).withNoIssueName(this.config.getNoIssueName()).withIgnoreCommitsWithoutIssue(this.config.isIgnoreCommitsWithoutIssue()).withTimeZone(this.config.getTimeZone()).withUntaggedName(this.config.getUntaggedName());
            if (this.config.isUseJira()) {
                gitChangelogApiBuilder.withJiraServer(this.config.getJiraServer()).withJiraIssuePattern(this.config.getJiraIssuePattern()).withJiraUsername(this.config.getJiraUsername()).withJiraPassword(this.config.getJiraPassword());
            }
            if (this.config.isUseGitHub()) {
                gitChangelogApiBuilder.withGitHubApi(this.config.getGitHubApi()).withGitHubIssuePattern(this.config.getGitHubIssuePattern()).withGitHubToken(this.config.getGitHubToken());
            }
            if (this.config.isUseGitLab()) {
                gitChangelogApiBuilder.withGitLabServer(this.config.getGitLabServer()).withGitLabProjectName(this.config.getGitLabProjectName()).withGitLabToken(this.config.getGitLabToken());
            }
            if (this.config.isUseReadableTagName() && !Strings.isNullOrEmpty((String)this.config.getReadableTagName())) {
                gitChangelogApiBuilder.withReadableTagName(this.config.getReadableTagName());
            }
            if (this.config.isUseIgnoreTagsIfNameMatches() && !Strings.isNullOrEmpty((String)this.config.getIgnoreTagsIfNameMatches())) {
                gitChangelogApiBuilder.withIgnoreTagsIfNameMatches(this.config.getIgnoreTagsIfNameMatches());
            }
            if (Strings.isNullOrEmpty((String)this.config.getFromType()) || GitChangelogConfigHelper.FROMTYPE.valueOf(this.config.getFromType()) == GitChangelogConfigHelper.FROMTYPE.firstCommit) {
                gitChangelogApiBuilder.withFromCommit(GitChangelogConfigHelper.FROMTYPE.firstCommit.getReference());
            } else if (GitChangelogConfigHelper.FROMTYPE.valueOf(this.config.getFromType()) == GitChangelogConfigHelper.FROMTYPE.ref && !Strings.isNullOrEmpty((String)this.config.getFromReference())) {
                gitChangelogApiBuilder.withFromRef(this.config.getFromReference());
            } else if (GitChangelogConfigHelper.FROMTYPE.valueOf(this.config.getFromType()) == GitChangelogConfigHelper.FROMTYPE.commit && !Strings.isNullOrEmpty((String)this.config.getFromReference())) {
                gitChangelogApiBuilder.withFromCommit(this.config.getFromReference());
            } else {
                gitChangelogApiBuilder.withFromRef(GitChangelogConfigHelper.FROMTYPE.firstCommit.getReference());
            }
            if (Strings.isNullOrEmpty((String)this.config.getToType()) || GitChangelogConfigHelper.FROMTYPE.valueOf(this.config.getToType()) == GitChangelogConfigHelper.FROMTYPE.master) {
                gitChangelogApiBuilder.withToRef(GitChangelogConfigHelper.FROMTYPE.master.getReference());
            } else if (GitChangelogConfigHelper.FROMTYPE.valueOf(this.config.getToType()) == GitChangelogConfigHelper.FROMTYPE.ref && !Strings.isNullOrEmpty((String)this.config.getToReference())) {
                gitChangelogApiBuilder.withToRef(this.config.getToReference());
            } else if (GitChangelogConfigHelper.FROMTYPE.valueOf(this.config.getToType()) == GitChangelogConfigHelper.FROMTYPE.commit && !Strings.isNullOrEmpty((String)this.config.getToReference())) {
                gitChangelogApiBuilder.withToCommit(this.config.getToReference());
            } else {
                gitChangelogApiBuilder.withToRef(GitChangelogConfigHelper.FROMTYPE.firstCommit.getReference());
            }
            for (CustomIssue ci : this.config.getCustomIssues()) {
                if (Strings.isNullOrEmpty((String)ci.getName()) || Strings.isNullOrEmpty((String)ci.getPattern())) continue;
                gitChangelogApiBuilder.withCustomIssue(ci.getName(), ci.getPattern(), ci.getLink(), ci.getTitle());
            }
            if (this.config.showSummary()) {
                if (this.config.isShowSummaryUseTemplateFile() && !Strings.isNullOrEmpty((String)this.config.getShowSummaryTemplateFile())) {
                    gitChangelogApiBuilder.withTemplatePath(this.workspacePath + "/" + this.config.getShowSummaryTemplateFile());
                }
                if (this.config.isShowSummaryUseTemplateContent() && !Strings.isNullOrEmpty((String)this.config.getShowSummaryTemplateContent())) {
                    gitChangelogApiBuilder.withTemplateContent(this.config.getShowSummaryTemplateContent());
                }
                remoteResult.setSummary(gitChangelogApiBuilder.render());
            }
            if (this.config.isUseMediaWiki()) {
                if (this.config.isMediaWikiUseTemplateFile() && !Strings.isNullOrEmpty((String)this.config.getMediaWikiTemplateFile())) {
                    gitChangelogApiBuilder.withTemplatePath(this.workspacePath + "/" + this.config.getMediaWikiTemplateFile());
                }
                if (this.config.isMediaWikiUseTemplateContent() && !Strings.isNullOrEmpty((String)this.config.getMediaWikiTemplateContent())) {
                    gitChangelogApiBuilder.withTemplateContent(this.config.getMediaWikiTemplateContent());
                }
                String mediaWikiFullUrl = this.config.getMediaWikiUrl() + "/index.php/" + this.config.getMediaWikiTitle();
                logString.append("Posting changelog to ").append(mediaWikiFullUrl);
                gitChangelogApiBuilder.toMediaWiki(this.config.getMediaWikiUsername(), this.config.getMediaWikiPassword(), this.config.getMediaWikiUrl(), this.config.getMediaWikiTitle());
                remoteResult.setLeftSide(this.config.getMediaWikiTitle(), mediaWikiFullUrl);
            }
            if (this.config.isUseFile()) {
                if (this.config.isCreateFileUseTemplateFile() && !Strings.isNullOrEmpty((String)this.config.getCreateFileTemplateFile())) {
                    gitChangelogApiBuilder.withTemplatePath(this.workspacePath + "/" + this.config.getCreateFileTemplateFile());
                }
                if (this.config.isCreateFileUseTemplateContent() && !Strings.isNullOrEmpty((String)this.config.getCreateFileTemplateContent())) {
                    gitChangelogApiBuilder.withTemplateContent(this.config.getCreateFileTemplateContent());
                }
                logString.append("Creating changelog ").append(this.config.toFile());
                File toFile = new File(this.workspacePath + "/" + this.config.toFile());
                new File(toFile.getParent()).mkdirs();
                Files.write((CharSequence)gitChangelogApiBuilder.render(), (File)toFile, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Throwable e) {
            logString.append(ExceptionUtils.getStackTrace((Throwable)e));
        }
        remoteResult.setLog(logString.toString());
        return remoteResult;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }
}

