/*
 * Decompiled with CFR 0.152.
 */
package de.wellnerbou.jenkins.gitchangelog.publish;

import de.wellnerbou.gitchangelog.processors.ChangelogProcessor;
import de.wellnerbou.gitchangelog.processors.jira.JiraFilterChangelogProcessor;
import de.wellnerbou.jenkins.gitchangelog.publish.GitLogGenericPostPublishPerformer;
import de.wellnerbou.jenkins.gitchangelog.publish.GitLogGenericPostPublishPerformerBuilder;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitLogJiraFilterPostPublisher
extends Recorder {
    public final String jirabaseurl;
    public final String jiraprefix;
    public final String outputfile;
    public final String toRev;
    public final String fromRev;

    @DataBoundConstructor
    public GitLogJiraFilterPostPublisher(String jirabaseurl, String jiraprefix, String outputfile, String fromRev, String toRev) {
        this.jirabaseurl = jirabaseurl;
        this.jiraprefix = jiraprefix;
        this.outputfile = outputfile;
        this.fromRev = fromRev;
        this.toRev = toRev;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        GitLogGenericPostPublishPerformer performer = new GitLogGenericPostPublishPerformerBuilder().setChangelogProcessor(this.createChangelogProcessor(build.getEnvironment((TaskListener)listener))).withFromRev(this.fromRev).withToRev(this.toRev).writeTofile(this.outputfile).build();
        performer.perform(build, listener);
        return true;
    }

    private ChangelogProcessor createChangelogProcessor(EnvVars env) {
        JiraFilterChangelogProcessor jiraFilterChangelogProcessor = new JiraFilterChangelogProcessor();
        jiraFilterChangelogProcessor.setJiraBaseUrl(env.expand(this.jirabaseurl));
        jiraFilterChangelogProcessor.setJiraProjectPrefixes(env.expand(this.jiraprefix));
        return jiraFilterChangelogProcessor;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Publish JIRA Filter";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

