/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.render;

import de.vandermeer.asciitable.commons.ArrayTransformations;
import de.vandermeer.asciitable.v2.render.BorderPosition;
import de.vandermeer.asciitable.v2.render.BorderType;
import de.vandermeer.asciitable.v2.render.ProcessedRow;
import de.vandermeer.asciitable.v2.row.ContentRow;
import de.vandermeer.asciitable.v2.row.RuleRow;
import de.vandermeer.asciitable.v2.row.V2_Row;
import de.vandermeer.asciitable.v2.themes.V2_RowTheme;

public abstract class RenderUtilities {
    public static final String[][] createContentArray(Object[] columns, int[] width, int[] padding) {
        String[][] ret = new String[width.length][];
        int length = 0;
        for (int i = 0; i < columns.length; ++i) {
            Object o = columns[i];
            if (o == null) {
                length += width[i];
                continue;
            }
            length += width[i];
            if (padding[i] > 0) {
                length -= padding[i] * 2;
            }
            String[] content = ArrayTransformations.PROCESS_CONTENT(o);
            ret[i] = ArrayTransformations.WRAP_LINES(length, content);
            length = 0;
        }
        ret = ArrayTransformations.NORMALISE_ARRAY(width.length, ret);
        ret = ArrayTransformations.FLIP_ARRAY(ret);
        return ret;
    }

    public static final BorderType[] getBorderTypes_BottomRule(ProcessedRow prev, V2_Row row, int colNumbers) {
        BorderType[] relAdj;
        BorderType[] ret = null;
        if (!(row instanceof RuleRow)) {
            return ret;
        }
        ret = new BorderType[colNumbers + 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = BorderType.NONE;
        }
        if (prev != null && (relAdj = prev.getBorderTypes()) != null) {
            block8: for (int i = 0; i < relAdj.length; ++i) {
                switch (relAdj[i]) {
                    case NONE: {
                        ret[i] = BorderType.NONE;
                        continue block8;
                    }
                    case UP: {
                        ret[i] = BorderType.NONE;
                        continue block8;
                    }
                    case ALL: {
                        ret[i] = BorderType.UP;
                        continue block8;
                    }
                    case DOWN: {
                        ret[i] = BorderType.UP;
                        continue block8;
                    }
                    case CONTENT: {
                        ret[i] = BorderType.UP;
                    }
                }
            }
        }
        return ret;
    }

    public static final BorderType[] getBorderTypes_ContentRow(String[] ar, ContentRow original, int colNumbers) {
        BorderType[] ret = null;
        ret = new BorderType[colNumbers + 1];
        ret[0] = BorderType.CONTENT;
        ret[colNumbers] = BorderType.CONTENT;
        for (int i = 0; i < ar.length; ++i) {
            String content = ar[i];
            if (content == null) {
                if (i == ar.length - 1) {
                    ret[i + 1] = BorderType.NONE;
                    continue;
                }
                ret[i + 1] = BorderType.NONE;
                continue;
            }
            ret[i + 1] = "".equals(content) ? BorderType.CONTENT : BorderType.CONTENT;
        }
        return ret;
    }

    public static final BorderType[] getBorderTypes_MidRule(ProcessedRow prev, ProcessedRow next, V2_Row row, int colNumbers) {
        int i;
        BorderType[] relAdj;
        BorderType[] ret = null;
        if (!(row instanceof RuleRow)) {
            return ret;
        }
        ret = new BorderType[colNumbers + 1];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = BorderType.NONE;
        }
        if (prev != null && (relAdj = prev.getBorderTypes()) != null) {
            block12: for (i = 0; i < relAdj.length; ++i) {
                switch (relAdj[i]) {
                    case NONE: {
                        ret[i] = BorderType.NONE;
                        continue block12;
                    }
                    case UP: {
                        ret[i] = BorderType.NONE;
                        continue block12;
                    }
                    case ALL: {
                        ret[i] = BorderType.UP;
                        continue block12;
                    }
                    case DOWN: {
                        ret[i] = BorderType.UP;
                        continue block12;
                    }
                    case CONTENT: {
                        ret[i] = BorderType.UP;
                    }
                }
            }
        }
        if (next != null && (relAdj = next.getBorderTypes()) != null) {
            block13: for (i = 0; i < relAdj.length; ++i) {
                switch (relAdj[i]) {
                    case NONE: 
                    case DOWN: {
                        continue block13;
                    }
                    case UP: 
                    case ALL: 
                    case CONTENT: {
                        ret[i] = ret[i] == BorderType.UP ? BorderType.ALL : BorderType.DOWN;
                    }
                }
            }
        }
        return ret;
    }

    public static final BorderType[] getBorderTypes_TopRule(ProcessedRow next, V2_Row row, int colNumbers) {
        BorderType[] relAdj;
        BorderType[] ret = null;
        if (!(row instanceof RuleRow)) {
            return ret;
        }
        ret = new BorderType[colNumbers + 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = BorderType.NONE;
        }
        if (next != null && (relAdj = next.getBorderTypes()) != null) {
            block8: for (int i = 0; i < relAdj.length; ++i) {
                switch (relAdj[i]) {
                    case NONE: {
                        ret[i] = BorderType.NONE;
                        continue block8;
                    }
                    case UP: {
                        ret[i] = BorderType.DOWN;
                        continue block8;
                    }
                    case ALL: {
                        ret[i] = BorderType.DOWN;
                        continue block8;
                    }
                    case DOWN: {
                        ret[i] = BorderType.NONE;
                        continue block8;
                    }
                    case CONTENT: {
                        ret[i] = BorderType.DOWN;
                    }
                }
            }
        }
        return ret;
    }

    public static char getChar(BorderPosition pos, BorderType type, V2_RowTheme tr) {
        switch (type) {
            case ALL: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
                break;
            }
            case CONTENT: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
                break;
            }
            case DOWN: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderDown();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
                break;
            }
            case NONE: {
                return tr.getMid();
            }
            case UP: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderUp();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
        }
        return 'X';
    }
}

