/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.commons;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrTokenizer;
import org.apache.commons.lang3.text.WordUtils;

public abstract class ArrayTransformations {
    public static final <T> StrBuilder ARRAY_TO_STRING(T[][] ar) {
        StrBuilder ret = new StrBuilder(50);
        for (int row = 0; row < ar.length; ++row) {
            if (ar[row] == null) {
                ret.append("[").append(row).appendln("]: null");
                continue;
            }
            if (ar[row].length == 0) {
                ret.append("[").append(row).appendln("]: 0");
                continue;
            }
            for (int col = 0; col < ar[row].length; ++col) {
                ret.append("[").append(row).append("][").append(col).append("]: ");
                if (ar[row][col] == null) {
                    ret.appendln("null");
                    continue;
                }
                if ("".equals(ar[row][col])) {
                    ret.appendln("0");
                    continue;
                }
                ret.appendln(ar[row][col]);
            }
        }
        return ret;
    }

    public static final String[][] FLIP_ARRAY(String[][] ar) {
        if (ar == null) {
            return null;
        }
        String[][] ret = new String[ar[0].length][ar.length];
        for (int i = 0; i < ar[0].length; ++i) {
            for (int k = 0; k < ar.length; ++k) {
                ret[i][k] = ar[k][i];
            }
        }
        return ret;
    }

    public static final String[][] NORMALISE_ARRAY(int length, String[][] ar) {
        int width = 0;
        for (int row = 0; row < ar.length; ++row) {
            width = Math.max(width, ArrayUtils.getLength((Object)ar[row]));
        }
        if (width == 0) {
            width = 1;
        }
        String[][] ret = new String[length][width];
        for (int row = 0; row < ar.length; ++row) {
            int i;
            if (ar[row] == null) {
                for (i = 0; i < width; ++i) {
                    ret[row][i] = null;
                }
                continue;
            }
            if (ar[row].length == 0) {
                for (i = 0; i < width; ++i) {
                    ret[row][i] = "";
                }
                continue;
            }
            for (int col = 0; col < ar[row].length; ++col) {
                ret[row][col] = ar[row][col];
            }
            if (ar[row].length >= width) continue;
            for (i = ar[row].length; i < width; ++i) {
                ret[row][i] = "";
            }
        }
        return ret;
    }

    public static final String[] PROCESS_CONTENT(Object content) {
        if (content == null || content.toString() == null) {
            return null;
        }
        if ("".equals(content)) {
            return new String[0];
        }
        String lfRep = StringUtils.replacePattern((String)content.toString(), (String)"\\r\\n|\\r|\\n", (String)"<br>");
        lfRep = StringUtils.replace((String)lfRep, (String)"<br>", (String)"<br/>");
        StrTokenizer tok = new StrTokenizer(lfRep, "<br/>").setIgnoreEmptyTokens(false);
        return tok.getTokenArray();
    }

    public static final String[] WRAP_LINES(int length, String[] ar) {
        if (ar == null) {
            return null;
        }
        Object[] ret = new String[]{};
        for (int i = 0; i < ar.length; ++i) {
            ret = StringUtils.isBlank((CharSequence)ar[i]) ? (String[])ArrayUtils.add((Object[])ret, (Object)ar[i]) : (String[])ArrayUtils.addAll((Object[])ret, (Object[])ArrayTransformations.WRAP_LINES(length, ar[i]));
        }
        return ret;
    }

    public static final String[] WRAP_LINES(int length, Object obj) {
        if (obj == null || obj.toString() == null) {
            return null;
        }
        if ("".equals(obj)) {
            return new String[0];
        }
        return StringUtils.split((String)WordUtils.wrap((String)obj.toString(), (int)length, (String)"@@@@", (boolean)true), (String)"@@@@");
    }
}

