/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.render;

import de.vandermeer.asciitable.commons.ArrayTransformations;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.BorderPosition;
import de.vandermeer.asciitable.v2.render.BorderType;
import de.vandermeer.asciitable.v2.render.ProcessedRow;
import de.vandermeer.asciitable.v2.row.ContentRow;
import de.vandermeer.asciitable.v2.row.RuleRow;
import de.vandermeer.asciitable.v2.row.RuleType;
import de.vandermeer.asciitable.v2.row.V2_Row;
import de.vandermeer.asciitable.v2.themes.V2_RowTheme;

public abstract class V2_Utilities {
    public static void fixTableRules(V2_AsciiTable table) {
        if (table.getTable().get(0) instanceof RuleRow) {
            ((RuleRow)table.getTable().get(0)).setRuleType(RuleType.TOP);
        }
        if (table.getTable().get(table.getTable().size() - 1) instanceof RuleRow) {
            ((RuleRow)table.getTable().get(table.getTable().size() - 1)).setRuleType(RuleType.BOTTOM);
        }
    }

    public static char getChar(BorderPosition pos, BorderType type, V2_RowTheme tr) {
        switch (type) {
            case ALL: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
                break;
            }
            case CONTENT: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
                break;
            }
            case DOWN: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderDown();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
                break;
            }
            case NONE: {
                return tr.getMid();
            }
            case UP: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderUp();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
        }
        return 'X';
    }

    public static final BorderType[] getBorderTypes_ContentRow(String[] ar, ContentRow original, int colNumbers) {
        BorderType[] ret = null;
        ret = new BorderType[colNumbers + 1];
        ret[0] = BorderType.CONTENT;
        ret[colNumbers] = BorderType.CONTENT;
        for (int i = 0; i < ar.length; ++i) {
            String content = ar[i];
            if (content == null) {
                if (i == ar.length - 1) {
                    ret[i + 1] = BorderType.NONE;
                    continue;
                }
                ret[i + 1] = BorderType.NONE;
                continue;
            }
            ret[i + 1] = "".equals(content) ? BorderType.CONTENT : BorderType.CONTENT;
        }
        return ret;
    }

    public static final BorderType[] getBorderTypes_TopRule(ProcessedRow next, V2_Row row, int colNumbers) {
        BorderType[] ret = null;
        if (!(row instanceof RuleRow)) {
            return ret;
        }
        RuleRow original = (RuleRow)row;
        switch (original.getRuleType()) {
            case TOP: {
                BorderType[] relAdj;
                ret = new BorderType[colNumbers + 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = BorderType.NONE;
                }
                if (next == null || (relAdj = next.getBorderTypes()) == null) break;
                block11: for (int i = 0; i < relAdj.length; ++i) {
                    switch (relAdj[i]) {
                        case NONE: {
                            ret[i] = BorderType.NONE;
                            continue block11;
                        }
                        case UP: {
                            ret[i] = BorderType.DOWN;
                            continue block11;
                        }
                        case ALL: {
                            ret[i] = BorderType.DOWN;
                            continue block11;
                        }
                        case DOWN: {
                            ret[i] = BorderType.NONE;
                            continue block11;
                        }
                        case CONTENT: {
                            ret[i] = BorderType.DOWN;
                        }
                    }
                }
                break;
            }
        }
        return ret;
    }

    public static final BorderType[] getBorderTypes_BottomRule(ProcessedRow prev, V2_Row row, int colNumbers) {
        BorderType[] ret = null;
        if (!(row instanceof RuleRow)) {
            return ret;
        }
        RuleRow original = (RuleRow)row;
        switch (original.getRuleType()) {
            case BOTTOM: {
                BorderType[] relAdj;
                ret = new BorderType[colNumbers + 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = BorderType.NONE;
                }
                if (prev == null || (relAdj = prev.getBorderTypes()) == null) break;
                block11: for (int i = 0; i < relAdj.length; ++i) {
                    switch (relAdj[i]) {
                        case NONE: {
                            ret[i] = BorderType.NONE;
                            continue block11;
                        }
                        case UP: {
                            ret[i] = BorderType.NONE;
                            continue block11;
                        }
                        case ALL: {
                            ret[i] = BorderType.UP;
                            continue block11;
                        }
                        case DOWN: {
                            ret[i] = BorderType.UP;
                            continue block11;
                        }
                        case CONTENT: {
                            ret[i] = BorderType.UP;
                        }
                    }
                }
                break;
            }
        }
        return ret;
    }

    public static final BorderType[] getBorderTypes_MidRule(ProcessedRow prev, ProcessedRow next, V2_Row row, int colNumbers) {
        BorderType[] ret = null;
        if (!(row instanceof RuleRow)) {
            return ret;
        }
        RuleRow original = (RuleRow)row;
        switch (original.getRuleType()) {
            case MID: {
                int i;
                BorderType[] relAdj;
                ret = new BorderType[colNumbers + 1];
                for (int i2 = 0; i2 < ret.length; ++i2) {
                    ret[i2] = BorderType.NONE;
                }
                if (prev != null && (relAdj = prev.getBorderTypes()) != null) {
                    block15: for (i = 0; i < relAdj.length; ++i) {
                        switch (relAdj[i]) {
                            case NONE: {
                                ret[i] = BorderType.NONE;
                                continue block15;
                            }
                            case UP: {
                                ret[i] = BorderType.NONE;
                                continue block15;
                            }
                            case ALL: {
                                ret[i] = BorderType.UP;
                                continue block15;
                            }
                            case DOWN: {
                                ret[i] = BorderType.UP;
                                continue block15;
                            }
                            case CONTENT: {
                                ret[i] = BorderType.UP;
                            }
                        }
                    }
                }
                if (next == null || (relAdj = next.getBorderTypes()) == null) break;
                block16: for (i = 0; i < relAdj.length; ++i) {
                    switch (relAdj[i]) {
                        case DOWN: 
                        case NONE: {
                            continue block16;
                        }
                        case ALL: 
                        case CONTENT: 
                        case UP: {
                            ret[i] = ret[i] == BorderType.UP ? BorderType.ALL : BorderType.DOWN;
                        }
                    }
                }
                break;
            }
        }
        return ret;
    }

    public static final String[][] createContentArray(Object[] columns, int[] width, int[] padding) {
        String[][] ret = new String[width.length][];
        int length = 0;
        for (int i = 0; i < columns.length; ++i) {
            Object o = columns[i];
            if (o == null) {
                length += width[i];
                continue;
            }
            length += width[i];
            if (padding[i] > 0) {
                length -= padding[i] * 2;
            }
            ret[i] = ArrayTransformations.WRAP_LINES(length, o);
            length = 0;
        }
        ret = ArrayTransformations.NORMALISE_ARRAY(width.length, ret);
        ret = ArrayTransformations.FLIP_ARRAY(ret);
        return ret;
    }
}

