/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.render;

import de.vandermeer.asciitable.v2.render.BorderType;
import de.vandermeer.asciitable.v2.render.V2_Utilities;
import de.vandermeer.asciitable.v2.row.ContentRow;
import de.vandermeer.asciitable.v2.row.V2_Row;

public class ProcessedRow {
    private V2_Row original;
    private String[][] procColumns;
    private BorderType[] borderTypes;

    public ProcessedRow(V2_Row row, int[] width, int colNumber) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.original = row;
        if (row instanceof ContentRow) {
            ContentRow crow = (ContentRow)row;
            this.procColumns = V2_Utilities.createContentArray(crow.getColumns(), width, crow.getPadding());
            this.borderTypes = V2_Utilities.getBorderTypes_ContentRow(this.procColumns[0], crow, colNumber);
        }
    }

    public final String[][] getProcessedColumns() {
        return this.procColumns;
    }

    public BorderType[] getBorderTypes() {
        return this.borderTypes;
    }

    public void setBorderTypes(BorderType[] array) {
        if (array != null) {
            this.borderTypes = array;
        }
    }

    public V2_Row getOriginalRow() {
        return this.original;
    }
}

