/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.core;

import de.vandermeer.asciitable.v2.core.V2_Width;

public class V2_WidthByAbsolute
implements V2_Width {
    int width = 0;

    public V2_WidthByAbsolute setWidth(int width) {
        if (width >= 3) {
            this.width = width;
        }
        return this;
    }

    @Override
    public int[] calculateWidth(int columnCount) {
        int[] ret = new int[columnCount + 1];
        if (this.width < columnCount * 3 + columnCount + 1) {
            throw new IllegalArgumentException("wrong width argument: width must allow for borders");
        }
        ret[0] = this.width;
        int distribute = this.width - 1 - columnCount;
        int colmin = distribute / columnCount;
        int leftover = distribute - colmin * columnCount;
        for (int i = 0; i < columnCount; ++i) {
            ret[i + 1] = colmin;
            if (leftover == 0) continue;
            int n = i + 1;
            ret[n] = ret[n] + 1;
            --leftover;
        }
        return ret;
    }
}

