/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.core;

import de.vandermeer.asciitable.commons.ObjectToStringStyle;
import de.vandermeer.asciitable.commons.TableException;
import de.vandermeer.asciitable.v2.core.V2_E_RuleStyle;
import de.vandermeer.asciitable.v2.core.V2_E_RuleType;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class V2_TableRow {
    Object[] columns;
    boolean[] borders;
    V2_E_RuleType ruleType;
    V2_E_RuleStyle ruleStyle;

    public V2_TableRow(V2_E_RuleType type, int columnCount) {
        this(type, V2_E_RuleStyle.NORMAL, columnCount);
    }

    public V2_TableRow(V2_E_RuleType type, V2_E_RuleStyle style, int columnCount) {
        this.ruleType = type;
        this.ruleStyle = style;
        this.columns = null;
        this.borders = new boolean[columnCount + 1];
        for (int i = 0; i < columnCount + 1; ++i) {
            this.borders[i] = true;
        }
        if (type == null) {
            throw new IllegalArgumentException("row type for rule cannot be null");
        }
        if (style == null) {
            throw new IllegalArgumentException("row style for rule cannot be null");
        }
    }

    public V2_TableRow(Object[] cols, int columnCount) throws TableException {
        if (cols == null) {
            throw new TableException("wrong columns argument", "empty column array");
        }
        if (cols.length != columnCount) {
            throw new TableException("wrong columns argument", "tried to add " + cols.length + " columns, expected " + this.columns + " columns");
        }
        this.ruleType = null;
        this.ruleStyle = null;
        this.columns = cols;
        this.borders = new boolean[cols.length + 1];
        for (int i = 0; i < columnCount + 1; ++i) {
            this.borders[i] = true;
        }
    }

    public boolean isRule() {
        return this.ruleType != null;
    }

    public boolean isContent() {
        return !this.isRule();
    }

    public V2_E_RuleType getRuleType() {
        return this.ruleType;
    }

    public V2_E_RuleStyle getRuleStyle() {
        return this.ruleStyle;
    }

    public void setRuleType(V2_E_RuleType type) {
        if (this.isRule() && type != null) {
            this.ruleType = type;
        }
    }

    public void setRuleStyle(V2_E_RuleStyle style) {
        if (this.isRule() && style != null) {
            this.ruleStyle = style;
        }
    }

    public String toString(int indent) {
        ToStringBuilder ret = new ToStringBuilder((Object)this, ObjectToStringStyle.getStyle(indent));
        if (this.isContent()) {
            ret.append("row type       ", (Object)("content with " + this.columns.length + " column(s)"));
            ret.append("columns        ", this.columns, false);
            ret.append("columns        ", this.columns);
        }
        if (this.isRule()) {
            ret.append("row type       ", (Object)("rule type " + (Object)((Object)this.ruleType) + " style " + (Object)((Object)this.ruleStyle)));
        }
        ret.append("borders        ", this.borders, false);
        ret.append("borders        ", this.borders);
        return ret.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

