/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2;

import de.vandermeer.asciitable.commons.ObjectToStringStyle;
import de.vandermeer.asciitable.commons.TableException;
import de.vandermeer.asciitable.v2.core.V2_E_RuleStyle;
import de.vandermeer.asciitable.v2.core.V2_E_RuleType;
import de.vandermeer.asciitable.v2.core.V2_TableRow;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class V2_AsciiTable {
    List<V2_TableRow> table = new LinkedList<V2_TableRow>();
    int columns;

    public V2_AsciiTable(int columns) {
        this.columns = columns;
    }

    public final void addRule() {
        if (this.table.size() == 0) {
            this.table.add(new V2_TableRow(V2_E_RuleType.TOP, this.columns));
        } else {
            this.table.add(new V2_TableRow(V2_E_RuleType.MID, this.columns));
        }
    }

    public final void addRuleStrong() {
        if (this.table.size() == 0) {
            this.table.add(new V2_TableRow(V2_E_RuleType.TOP, V2_E_RuleStyle.STRONG, this.columns));
        } else {
            this.table.add(new V2_TableRow(V2_E_RuleType.MID, V2_E_RuleStyle.STRONG, this.columns));
        }
    }

    public final V2_TableRow addRow(Object ... columns) throws TableException {
        V2_TableRow ret = new V2_TableRow(columns, this.columns);
        this.table.add(ret);
        return ret;
    }

    public final int getColumnCount() {
        return this.columns;
    }

    public void fixRules() {
        if (this.table.get(0).getRuleType() != null && !V2_E_RuleType.TOP.equals((Object)this.table.get(0).getRuleType())) {
            this.table.get(0).setRuleType(V2_E_RuleType.TOP);
        }
        if (V2_E_RuleType.MID.equals((Object)this.table.get(this.table.size() - 1).getRuleType())) {
            this.table.get(this.table.size() - 1).setRuleType(V2_E_RuleType.BOTTOM);
        }
    }

    public String toString() {
        ToStringBuilder ret = new ToStringBuilder((Object)this, ObjectToStringStyle.getStyle()).append("column count   ", this.columns).append("table          ", this.table, false).append((Object)"").append((Object)"------------------------------------").append((Object)"");
        if (this.table != null && this.table.size() > 0) {
            for (V2_TableRow row : this.table) {
                ret.append((Object)row.toString(4));
                ret.append((Object)"");
            }
        }
        ret.append((Object)"------------------------------------");
        return ret.toString();
    }

    public boolean validate() {
        if (this.getColumnCount() == 0) {
            throw new IllegalArgumentException("wrong table argument: table is null or has no columns");
        }
        return true;
    }
}

