/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.core;

import de.vandermeer.asciitable.commons.ArrayTransformations;
import de.vandermeer.asciitable.v2.core.V2_E_AdjustedBorderType;
import de.vandermeer.asciitable.v2.core.V2_TableRow;

public class V2_ProcessedRow {
    V2_TableRow original;
    String[][] procColumns;
    V2_E_AdjustedBorderType[] adjustedBorders;

    public V2_ProcessedRow(V2_TableRow row, int[] width) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.original = row;
        this._createContentArray(width);
        this._adjustBordersContentRow();
    }

    public final String[][] getProcessedColumns() {
        return this.procColumns;
    }

    public V2_E_AdjustedBorderType[] getAdjustedBorders() {
        return this.adjustedBorders;
    }

    public V2_TableRow getOriginalRow() {
        return this.original;
    }

    private final void _createContentArray(int[] width) {
        if (this.original.isContent()) {
            this.procColumns = new String[width.length - 1][];
            int length = 0;
            for (int i = 0; i < this.original.columns.length; ++i) {
                Object o = this.original.columns[i];
                if (o == null) {
                    length += width[i + 1];
                    continue;
                }
                this.procColumns[i] = ArrayTransformations.WRAP_LINES(length += width[i + 1], o);
                length = 0;
            }
            this.procColumns = ArrayTransformations.NORMALISE_ARRAY(width.length - 1, this.procColumns);
            this.procColumns = ArrayTransformations.FLIP_ARRAY(this.procColumns);
        } else {
            this.procColumns = null;
        }
    }

    private final void _adjustBordersContentRow() {
        if (this.original.isContent()) {
            this.adjustedBorders = new V2_E_AdjustedBorderType[this.original.columns.length + 1];
            if (this.original.borders[0]) {
                this.adjustedBorders[0] = V2_E_AdjustedBorderType.CONTENT;
            }
            if (this.original.borders[this.original.columns.length]) {
                this.adjustedBorders[this.original.columns.length] = V2_E_AdjustedBorderType.CONTENT;
            }
            String[] ar = this.procColumns[0];
            for (int i = 0; i < ar.length; ++i) {
                String content = ar[i];
                if (content == null) {
                    if (i == ar.length - 1) {
                        this.adjustedBorders[i + 1] = V2_E_AdjustedBorderType.NONE;
                        continue;
                    }
                    this.adjustedBorders[i + 1] = V2_E_AdjustedBorderType.NONE;
                    continue;
                }
                if ("".equals(content)) {
                    if (!this.original.borders[i + 1]) continue;
                    this.adjustedBorders[i + 1] = V2_E_AdjustedBorderType.CONTENT;
                    continue;
                }
                if (!this.original.borders[i + 1]) continue;
                this.adjustedBorders[i + 1] = V2_E_AdjustedBorderType.CONTENT;
            }
        }
    }

    public final void adjustTopRuleBorder(V2_ProcessedRow next) {
        if (this.original.isRule()) {
            switch (this.original.ruleType) {
                case TOP: {
                    V2_E_AdjustedBorderType[] relAdj;
                    this.adjustedBorders = new V2_E_AdjustedBorderType[this.original.borders.length];
                    for (int i = 0; i < this.adjustedBorders.length; ++i) {
                        this.adjustedBorders[i] = V2_E_AdjustedBorderType.NONE;
                    }
                    if (next == null || (relAdj = next.adjustedBorders) == null) break;
                    block11: for (int i = 0; i < relAdj.length; ++i) {
                        switch (relAdj[i]) {
                            case NONE: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.NONE;
                                continue block11;
                            }
                            case UP: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.DOWN;
                                continue block11;
                            }
                            case ALL: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.DOWN;
                                continue block11;
                            }
                            case DOWN: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.NONE;
                                continue block11;
                            }
                            case CONTENT: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.DOWN;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public final void adjustBottomRuleBorder(V2_ProcessedRow prev) {
        if (this.original.isRule()) {
            switch (this.original.ruleType) {
                case BOTTOM: {
                    V2_E_AdjustedBorderType[] relAdj;
                    this.adjustedBorders = new V2_E_AdjustedBorderType[this.original.borders.length];
                    for (int i = 0; i < this.adjustedBorders.length; ++i) {
                        this.adjustedBorders[i] = V2_E_AdjustedBorderType.NONE;
                    }
                    if (prev == null || (relAdj = prev.adjustedBorders) == null) break;
                    block11: for (int i = 0; i < relAdj.length; ++i) {
                        switch (relAdj[i]) {
                            case NONE: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.NONE;
                                continue block11;
                            }
                            case UP: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.NONE;
                                continue block11;
                            }
                            case ALL: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.UP;
                                continue block11;
                            }
                            case DOWN: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.UP;
                                continue block11;
                            }
                            case CONTENT: {
                                this.adjustedBorders[i] = V2_E_AdjustedBorderType.UP;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public final void adjustMidRuleBorder(V2_ProcessedRow prev, V2_ProcessedRow next) {
        if (this.original.isRule()) {
            switch (this.original.ruleType) {
                case MID: {
                    int i;
                    V2_E_AdjustedBorderType[] relAdj;
                    this.adjustedBorders = new V2_E_AdjustedBorderType[this.original.borders.length];
                    for (int i2 = 0; i2 < this.adjustedBorders.length; ++i2) {
                        this.adjustedBorders[i2] = V2_E_AdjustedBorderType.NONE;
                    }
                    if (prev != null && (relAdj = prev.adjustedBorders) != null) {
                        block15: for (i = 0; i < relAdj.length; ++i) {
                            switch (relAdj[i]) {
                                case NONE: {
                                    this.adjustedBorders[i] = V2_E_AdjustedBorderType.NONE;
                                    continue block15;
                                }
                                case UP: {
                                    this.adjustedBorders[i] = V2_E_AdjustedBorderType.NONE;
                                    continue block15;
                                }
                                case ALL: {
                                    this.adjustedBorders[i] = V2_E_AdjustedBorderType.UP;
                                    continue block15;
                                }
                                case DOWN: {
                                    this.adjustedBorders[i] = V2_E_AdjustedBorderType.UP;
                                    continue block15;
                                }
                                case CONTENT: {
                                    this.adjustedBorders[i] = V2_E_AdjustedBorderType.UP;
                                }
                            }
                        }
                    }
                    if (next == null || (relAdj = next.adjustedBorders) == null) break;
                    block16: for (i = 0; i < relAdj.length; ++i) {
                        switch (relAdj[i]) {
                            case NONE: 
                            case DOWN: {
                                continue block16;
                            }
                            case UP: 
                            case ALL: 
                            case CONTENT: {
                                this.adjustedBorders[i] = this.adjustedBorders[i] == V2_E_AdjustedBorderType.UP ? V2_E_AdjustedBorderType.ALL : V2_E_AdjustedBorderType.DOWN;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }
}

