/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2;

import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.V2_RenderedAsciiTable;
import de.vandermeer.asciitable.v2.core.V2_E_AdjustedBorderType;
import de.vandermeer.asciitable.v2.core.V2_E_BorderPosition;
import de.vandermeer.asciitable.v2.core.V2_ProcessedRow;
import de.vandermeer.asciitable.v2.core.V2_TableRow;
import de.vandermeer.asciitable.v2.core.V2_Width;
import de.vandermeer.asciitable.v2.themes.V2_E_TableThemes;
import de.vandermeer.asciitable.v2.themes.V2_RowTheme;
import de.vandermeer.asciitable.v2.themes.V2_TableTheme;
import de.vandermeer.asciitable.v2.themes.V2_Validator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class V2_AsciiTableRenderer {
    char paddingChar = (char)32;
    V2_TableTheme theme = V2_E_TableThemes.PLAIN_7BIT.get();
    V2_Width width = null;
    List<V2_ProcessedRow> rows = new LinkedList<V2_ProcessedRow>();

    public V2_AsciiTableRenderer setWidth(V2_Width width) {
        if (width != null) {
            this.width = width;
        }
        return this;
    }

    public V2_RenderedAsciiTable render(V2_AsciiTable table) {
        this.rows.clear();
        if (table == null || table.getColumnCount() == 0) {
            throw new IllegalArgumentException("wrong table argument: table is null or has no columns");
        }
        if (this.width == null) {
            throw new IllegalArgumentException("wrong table width argument: no width set");
        }
        int[] cols = this.width.calculateWidth(table.getColumnCount());
        boolean[] borders = new boolean[cols.length];
        for (int i = 0; i < borders.length; ++i) {
            borders[i] = true;
        }
        table.fixRules();
        for (V2_TableRow row : table.table) {
            this.rows.add(new V2_ProcessedRow(row, cols));
        }
        this.rows.get(0).adjustTopRuleBorder(this.rows.size() > 1 ? this.rows.get(1) : null);
        this.rows.get(this.rows.size() - 1).adjustBottomRuleBorder(this.rows.size() > 1 ? this.rows.get(this.rows.size() - 2) : null);
        if (this.rows.size() > 2) {
            for (int r = 1; r < this.rows.size() - 1; ++r) {
                this.rows.get(r).adjustMidRuleBorder(this.rows.get(r - 1), r < this.rows.size() - 2 ? this.rows.get(r + 1) : null);
            }
        }
        LinkedList<StrBuilder> ret = new LinkedList<StrBuilder>();
        for (V2_ProcessedRow row : this.rows) {
            ret.add(this.renderRow(row, cols));
        }
        return new V2_RenderedAsciiTable(ret);
    }

    protected final StrBuilder renderRow(V2_ProcessedRow row, int[] cols) {
        if (row.getOriginalRow().isContent()) {
            return this.renderContentRow(row, cols);
        }
        return this.renderRuleRow(row, cols);
    }

    protected final StrBuilder renderContentRow(V2_ProcessedRow row, int[] cols) {
        StrBuilder ret = new StrBuilder(100);
        V2_RowTheme rt = null;
        String[][] columns = row.getProcessedColumns();
        V2_E_AdjustedBorderType[] borders = row.getAdjustedBorders();
        for (int i = 0; i < columns.length; ++i) {
            rt = this.theme.getContent();
            if (i != 0) {
                ret.appendNewLine();
            }
            int span = 0;
            for (int k = 0; k < borders.length; ++k) {
                if (borders[k] != V2_E_AdjustedBorderType.NONE) {
                    if (k == 0) {
                        ret.append(this.getChar(V2_E_BorderPosition.LEFT, borders[k], rt));
                    } else if (k == borders.length - 1) {
                        ret.append(this.getChar(V2_E_BorderPosition.RIGHT, borders[k], rt));
                    } else {
                        ret.append(this.getChar(V2_E_BorderPosition.MIDDLE, borders[k], rt));
                    }
                }
                if (k >= columns[i].length) continue;
                if (ArrayUtils.contains((Object[])columns[i], null)) {
                    int s;
                    int width;
                    if (columns[i][k] == null) {
                        if (k == columns[i].length - 1) {
                            width = 0;
                            for (s = 0; s < span; ++s) {
                                width += cols[s + 1];
                            }
                            width += span;
                            ret.appendFixedWidthPadRight((Object)"", width += cols[k + 1], this.paddingChar);
                            continue;
                        }
                        ++span;
                        continue;
                    }
                    if ("".equals(columns[i][k])) {
                        for (int s2 = 0; s2 < span; ++s2) {
                            ret.appendFixedWidthPadRight((Object)"", cols[s2 + 1], this.paddingChar);
                        }
                        ret.appendFixedWidthPadRight((Object)"", span, this.paddingChar);
                        span = 0;
                        ret.appendFixedWidthPadRight((Object)columns[i][k], cols[k + 1], this.paddingChar);
                        continue;
                    }
                    width = 0;
                    for (s = 0; s < span; ++s) {
                        width += cols[s + 1];
                    }
                    width += span;
                    ret.append(StringUtils.center((String)columns[i][k], (int)(width += cols[k + 1]), (char)this.paddingChar));
                    span = 0;
                    continue;
                }
                ret.appendFixedWidthPadRight((Object)columns[i][k], cols[k + 1], this.paddingChar);
            }
        }
        return ret;
    }

    protected final StrBuilder renderRuleRow(V2_ProcessedRow row, int[] cols) {
        StrBuilder ret = new StrBuilder(100);
        V2_RowTheme rt = null;
        V2_E_AdjustedBorderType[] borders = row.getAdjustedBorders();
        block0 : switch (row.getOriginalRow().getRuleType()) {
            case BOTTOM: {
                switch (row.getOriginalRow().getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getBottom();
                        break;
                    }
                    case STRONG: {
                        rt = this.theme.getBottomStrong();
                    }
                }
                break;
            }
            case MID: {
                switch (row.getOriginalRow().getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getMid();
                        break;
                    }
                    case STRONG: {
                        rt = this.theme.getMidStrong();
                    }
                }
                break;
            }
            case TOP: {
                switch (row.getOriginalRow().getRuleStyle()) {
                    case NORMAL: {
                        rt = this.theme.getTop();
                        break block0;
                    }
                    case STRONG: {
                        rt = this.theme.getTopStrong();
                    }
                }
            }
        }
        for (int k = 0; k < borders.length; ++k) {
            if (k == 0) {
                ret.append(this.getChar(V2_E_BorderPosition.LEFT, borders[k], rt));
            } else if (k == borders.length - 1) {
                ret.append(this.getChar(V2_E_BorderPosition.RIGHT, borders[k], rt));
            } else {
                ret.append(this.getChar(V2_E_BorderPosition.MIDDLE, borders[k], rt));
            }
            if (k + 1 >= cols.length) continue;
            ret.appendPadding(cols[k + 1], rt.getMid());
        }
        return ret;
    }

    private char getChar(V2_E_BorderPosition pos, V2_E_AdjustedBorderType type, V2_RowTheme tr) {
        switch (type) {
            case ALL: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
            case CONTENT: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
            case DOWN: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderDown();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
            case NONE: {
                return tr.getMid();
            }
            case UP: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderUp();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
        }
        return 'X';
    }

    public V2_AsciiTableRenderer setPaddingChar(char pChar) {
        this.paddingChar = pChar;
        return this;
    }

    public V2_AsciiTableRenderer setTheme(V2_TableTheme theme) {
        if (theme != null) {
            V2_Validator.testTableTheme(theme);
            this.theme = theme;
        }
        return this;
    }
}

