/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.themes;

import de.vandermeer.asciitable.v2.themes.RowTheme;
import de.vandermeer.asciitable.v2.themes.TableTheme;
import de.vandermeer.asciitable.v2.themes.V2Validator;
import org.apache.commons.lang3.text.StrBuilder;

public class TableThemeBuilder {
    private RowTheme bottom;
    private RowTheme bottomStrong;
    private RowTheme content;
    private String description;
    private RowTheme mid;
    private RowTheme midStrong;
    private RowTheme top;
    private RowTheme topStrong;

    public TableThemeBuilder setBottom(RowTheme theme) {
        this.bottom = theme;
        return this;
    }

    public TableThemeBuilder setBottomStrong(RowTheme theme) {
        this.bottomStrong = theme;
        return this;
    }

    public TableThemeBuilder setContent(RowTheme theme) {
        this.content = theme;
        return this;
    }

    public TableThemeBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public TableThemeBuilder setMid(RowTheme theme) {
        this.mid = theme;
        return this;
    }

    public TableThemeBuilder setMidStrong(RowTheme theme) {
        this.midStrong = theme;
        return this;
    }

    public TableThemeBuilder setTop(RowTheme theme) {
        this.top = theme;
        return this;
    }

    public TableThemeBuilder setTopStrong(RowTheme theme) {
        this.topStrong = theme;
        return this;
    }

    public TableTheme build() {
        TableTheme ret = this.build(this.top, this.topStrong, this.mid, this.midStrong, this.bottom, this.bottomStrong, this.content, this.description);
        V2Validator.testTableTheme(ret);
        return ret;
    }

    private TableTheme build(final RowTheme top, final RowTheme topStrong, final RowTheme mid, final RowTheme midStrong, final RowTheme bottom, final RowTheme bottomStrong, final RowTheme content, final String description) {
        return new TableTheme(){

            @Override
            public RowTheme getTopStrong() {
                return topStrong;
            }

            @Override
            public RowTheme getTop() {
                return top;
            }

            @Override
            public RowTheme getMidStrong() {
                return midStrong;
            }

            @Override
            public RowTheme getMid() {
                return mid;
            }

            @Override
            public Object getDescription() {
                return description;
            }

            @Override
            public RowTheme getContent() {
                return content;
            }

            @Override
            public RowTheme getBottomStrong() {
                return bottomStrong;
            }

            @Override
            public RowTheme getBottom() {
                return bottom;
            }

            @Override
            public StrBuilder toDoc() {
                StrBuilder ret = new StrBuilder(50);
                ret.append(this.getTop().toDoc()).append("        ").append(this.getTopStrong().toDoc()).appendNewLine().append(this.getContent().toDoc()).append("        ").append(this.getContent().toDoc()).appendNewLine().append(this.getMid().toDoc()).append("        ").append(this.getMidStrong().toDoc()).appendNewLine().append(this.getContent().toDoc()).append("        ").append(this.getContent().toDoc()).appendNewLine().append(this.getBottom().toDoc()).append("        ").append(this.getBottomStrong().toDoc()).appendNewLine();
                return ret;
            }
        };
    }
}

