/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.core;

import de.vandermeer.asciitable.commons.TableException;
import de.vandermeer.asciitable.v2.core.E_RuleStyle;
import de.vandermeer.asciitable.v2.core.E_RuleType;

public class TableRow {
    Object[] columns;
    boolean[] borders;
    E_RuleType ruleType;
    E_RuleStyle ruleStyle;

    public TableRow(E_RuleType type, int columnCount) {
        this(type, E_RuleStyle.NORMAL, columnCount);
    }

    public TableRow(E_RuleType type, E_RuleStyle style, int columnCount) {
        this.ruleType = type;
        this.ruleStyle = style;
        this.columns = null;
        this.borders = new boolean[columnCount + 1];
        for (int i = 0; i < columnCount + 1; ++i) {
            this.borders[i] = true;
        }
        if (type == null) {
            throw new IllegalArgumentException("row type for rule cannot be null");
        }
        if (style == null) {
            throw new IllegalArgumentException("row style for rule cannot be null");
        }
    }

    public TableRow(Object[] cols, int columnCount) throws TableException {
        if (cols == null) {
            throw new TableException("wrong columns argument", "empty column array");
        }
        if (cols.length != columnCount) {
            throw new TableException("wrong columns argument", "tried to add " + cols.length + " columns, expected " + this.columns + " columns");
        }
        this.ruleType = null;
        this.ruleStyle = null;
        this.columns = cols;
        this.borders = new boolean[cols.length + 1];
        for (int i = 0; i < columnCount + 1; ++i) {
            this.borders[i] = true;
        }
    }

    public boolean isRule() {
        return this.ruleType != null;
    }

    public boolean isContent() {
        return !this.isRule();
    }

    public E_RuleType getRuleType() {
        return this.ruleType;
    }

    public E_RuleStyle getRuleStyle() {
        return this.ruleStyle;
    }

    public void setRuleType(E_RuleType type) {
        if (this.isRule() && type != null) {
            this.ruleType = type;
        }
    }

    public void setRuleStyle(E_RuleStyle style) {
        if (this.isRule() && style != null) {
            this.ruleStyle = style;
        }
    }
}

