/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v1;

import de.vandermeer.asciitable.commons.ArrayTransformations;
import de.vandermeer.asciitable.commons.Table_ToStringStyle;
import de.vandermeer.asciitable.v1.StandardTableThemes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.WordUtils;

public final class AsciiTable {
    char padChar = (char)32;
    StandardTableThemes theme = StandardTableThemes.PLAIN_7BIT;
    private Integer[] columns;
    protected Map<Integer, String[][]> table = new HashMap<Integer, String[][]>(10);

    public static AsciiTable newTable(Integer columns, Integer width) {
        AsciiTable ret = new AsciiTable();
        if (!ret._init(columns, width)) {
            return null;
        }
        return ret;
    }

    public static AsciiTable newTable(Integer[] columns) {
        AsciiTable ret = new AsciiTable();
        if (!ret._init(columns)) {
            return null;
        }
        return ret;
    }

    protected AsciiTable() {
    }

    public AsciiTable setPaddingCharacter(char padChar) {
        this.padChar = padChar;
        return this;
    }

    public AsciiTable setTheme(StandardTableThemes theme) {
        if (theme != null) {
            this.theme = theme;
        }
        return this;
    }

    public int addRow(Object ... columns) {
        if (this.columns == null) {
            return -1;
        }
        if (columns == null || columns.length != this.getColumnCount()) {
            return 0;
        }
        String[][] ar = new String[this.getColumnCount()][];
        for (int i = 0; i < columns.length; ++i) {
            Object o = columns[i];
            ar[i] = this.obj2At(o, i + 1);
        }
        ar = ArrayTransformations.NORMALISE_ARRAY(this.getColumnCount(), ar);
        ar = ArrayTransformations.FLIP_ARRAY(ar);
        this.table.put(this.table.size() + 1, ar);
        return this.table.size();
    }

    public Integer[] getColumnAr() {
        if (this.columns == null) {
            return null;
        }
        return (Integer[])this.columns.clone();
    }

    public int getColumnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.length - 1;
    }

    public int getWidth() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns[0];
    }

    protected final boolean _init(Integer columns, Integer width) {
        if (columns == null || columns < 1) {
            return false;
        }
        if (width == null || width < columns * 3 + columns + 1) {
            return false;
        }
        this.columns = new Integer[columns + 1];
        this.columns[0] = width;
        int distribute = width - 1 - columns;
        int colmin = distribute / columns;
        int leftover = distribute - colmin * columns;
        for (int i = 0; i < columns; ++i) {
            this.columns[i + 1] = colmin;
            if (leftover == 0) continue;
            Integer[] integerArray = this.columns;
            int n = i + 1;
            Integer.valueOf(integerArray[n] + 1);
            --leftover;
        }
        return true;
    }

    protected final boolean _init(Integer[] columns) {
        if (columns == null || columns.length < 1) {
            return false;
        }
        Integer[] col = new Integer[columns.length + 1];
        col[0] = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null || columns[i] < 3) {
                return false;
            }
            Integer[] integerArray = col;
            Integer.valueOf(integerArray[0] + columns[i]);
            col[i + 1] = columns[i];
        }
        Integer[] integerArray = col;
        Integer.valueOf(integerArray[0] + (columns.length + 1));
        this.columns = col;
        return true;
    }

    protected final String[] obj2At(Object obj, int colP) {
        if (obj == null || obj.toString() == null) {
            return null;
        }
        if ("".equals(obj)) {
            return new String[0];
        }
        return StringUtils.split((String)WordUtils.wrap((String)obj.toString(), (int)this.columns[colP], (String)"@@@", (boolean)true), (String)"@@@");
    }

    public String render() {
        StrBuilder ret = new StrBuilder(1000);
        List<StrBuilder> tab = this.renderTable(this.padChar, this.theme.getTheme());
        for (StrBuilder b : tab) {
            ret.appendln(b);
        }
        return ret.toString();
    }

    protected final StrBuilder renderMiddleRule(String[][] top, String[][] bot, char[] theme) {
        StrBuilder ret = new StrBuilder(100);
        ret.append(theme[10]);
        String[] topSt = top[top.length - 1];
        String[] botSt = bot[0];
        for (int i = 0; i < topSt.length; ++i) {
            ret.appendPadding(this.columns[i + 1].intValue(), theme[3]);
            if (i >= topSt.length - 1) continue;
            if (topSt[i] == null && botSt[i] == null) {
                ret.append(theme[3]);
                continue;
            }
            if (topSt[i] == null) {
                ret.append(theme[0]);
                continue;
            }
            if (botSt[i] == null) {
                ret.append(theme[4]);
                continue;
            }
            ret.append(theme[8]);
        }
        ret.append(theme[9]);
        return ret;
    }

    protected final StrBuilder renderBottomRule(String[][] row, char[] theme) {
        StrBuilder ret = new StrBuilder(100);
        ret.append(theme[6]);
        String[] ar = row[row.length - 1];
        for (int i = 0; i < ar.length; ++i) {
            ret.appendPadding(this.columns[i + 1].intValue(), theme[3]);
            if (i >= ar.length - 1) continue;
            if (ar[i] == null) {
                ret.append(theme[3]);
                continue;
            }
            ret.append(theme[4]);
        }
        ret.append(theme[5]);
        return ret;
    }

    protected final StrBuilder renderRow(String[][] row, char padChar, char[] theme) {
        StrBuilder ret = new StrBuilder(100);
        ret.setNullText("");
        for (int k = 0; k < row.length; ++k) {
            Object[] ar = row[k];
            ret.append(theme[7]);
            if (ArrayUtils.contains((Object[])ar, null)) {
                int span = 0;
                for (int i = 0; i < ar.length; ++i) {
                    int width;
                    Object content = ar[i];
                    if (content == null) {
                        if (i == ar.length - 1) {
                            width = 0;
                            for (k = 0; k < span; ++k) {
                                width += this.columns[k + 1].intValue();
                            }
                            width += span;
                            ret.appendFixedWidthPadRight((Object)"", width += this.columns[i + 1].intValue(), padChar);
                            continue;
                        }
                        ++span;
                        continue;
                    }
                    if ("".equals(content)) {
                        for (k = 0; k < span; ++k) {
                            ret.appendFixedWidthPadRight((Object)"", this.columns[k + 1].intValue(), padChar);
                        }
                        ret.appendFixedWidthPadRight((Object)"", span, padChar);
                        ret.append(theme[7]);
                        span = 0;
                        ret.appendFixedWidthPadRight(content, this.columns[i + 1].intValue(), padChar);
                        if (i >= ar.length - 1) continue;
                        ret.append(theme[7]);
                        continue;
                    }
                    width = 0;
                    for (k = 0; k < span; ++k) {
                        width += this.columns[k + 1].intValue();
                    }
                    width += span;
                    ret.append(StringUtils.center((String)content, (int)(width += this.columns[i + 1].intValue()), (char)padChar));
                    if (i < ar.length - 1) {
                        ret.append(theme[7]);
                    }
                    span = 0;
                }
            } else {
                for (int i = 0; i < ar.length; ++i) {
                    Object content = ar[i];
                    ret.appendFixedWidthPadRight(content, this.columns[i + 1].intValue(), padChar);
                    if (i >= ar.length - 1) continue;
                    ret.append(theme[7]);
                }
            }
            ret.append(theme[7]);
            if (k >= row.length - 1) continue;
            ret.append('\n');
        }
        return ret;
    }

    protected final List<StrBuilder> renderTable(char padChar, char[] theme) {
        ArrayList<StrBuilder> ret = new ArrayList<StrBuilder>();
        if (this.table.size() > 0) {
            ret.add(this.renderTopRule(this.table.get(1), theme));
            if (this.table.size() > 1) {
                for (int i = 1; i < this.table.size(); ++i) {
                    ret.add(this.renderRow(this.table.get(i), padChar, theme));
                    ret.add(this.renderMiddleRule(this.table.get(i), this.table.get(i + 1), theme));
                }
            }
            ret.add(this.renderRow(this.table.get(this.table.size()), padChar, theme));
            ret.add(this.renderBottomRule(this.table.get(this.table.size()), theme));
        }
        return ret;
    }

    protected final StrBuilder renderTopRule(String[][] row, char[] theme) {
        StrBuilder ret = new StrBuilder(100);
        ret.append(theme[2]);
        String[] ar = row[0];
        for (int i = 0; i < ar.length; ++i) {
            ret.appendPadding(this.columns[i + 1].intValue(), theme[3]);
            if (i >= ar.length - 1) continue;
            if (ar[i] == null) {
                ret.append(theme[3]);
                continue;
            }
            ret.append(theme[0]);
        }
        ret.append(theme[1]);
        return ret;
    }

    public String toString() {
        ToStringBuilder ret = new ToStringBuilder((Object)this, Table_ToStringStyle.TS_STYLE).append("columns   ", (Object[])this.columns, false).append("columns   ", (Object[])this.columns).append((Object)"------------------------------------").append("table     ", this.table, false);
        if (this.table != null && this.table.size() > 0) {
            for (Integer i : this.table.keySet()) {
                ret.append(String.format("  row(%3d)", i), (Object[])this.table.get(i));
            }
        }
        ret.append((Object)"------------------------------------");
        return ret.toString();
    }
}

