/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2;

import de.vandermeer.asciitable.commons.ArrayTransformations;
import de.vandermeer.asciitable.commons.TableException;
import de.vandermeer.asciitable.v2.AdjustedBorderType;
import de.vandermeer.asciitable.v2.TableRow;
import de.vandermeer.asciitable.v2.TableRowType;
import de.vandermeer.asciitable.v2.themes.SimpleThemes;
import de.vandermeer.asciitable.v2.themes.ThemeRow;
import de.vandermeer.asciitable.v2.themes.ThemeSimple;
import de.vandermeer.asciitable.v2.themes.ThemeTB;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;

public class TableRowRenderer {
    int columnCount;
    Integer[] columnWidth;
    char paddingChar = (char)32;
    ThemeSimple ts = SimpleThemes.PLAIN_7BIT;
    ThemeTB tb = null;
    boolean[] borders;

    public TableRowRenderer(int columnCount, Integer tableWidth) throws TableException {
        int i;
        this.columnCount = columnCount;
        this.columnWidth = new Integer[this.columnCount + 1];
        if (tableWidth == null || tableWidth == 0) {
            throw new TableException("wrong table width argument", "table width is null or 0");
        }
        if (tableWidth < this.columnCount * 3 + this.columnCount + 1) {
            throw new TableException("wrong width argument", "width must allow for borders");
        }
        this.columnWidth[0] = tableWidth;
        int distribute = tableWidth - 1 - this.columnCount;
        int colmin = distribute / this.columnCount;
        int leftover = distribute - colmin * this.columnCount;
        for (i = 0; i < this.columnCount; ++i) {
            this.columnWidth[i + 1] = colmin;
            if (leftover == 0) continue;
            Integer[] integerArray = this.columnWidth;
            int n = i + 1;
            Integer.valueOf(integerArray[n] + 1);
            --leftover;
        }
        this.borders = new boolean[this.columnCount + 1];
        for (i = 0; i < this.columnCount + 1; ++i) {
            this.borders[i] = true;
        }
    }

    public TableRowRenderer(int columnCount, Integer[] columns) throws TableException {
        this.columnCount = columnCount;
        this.columnWidth = new Integer[this.columnCount + 1];
        if (columns == null || columns.length == 0) {
            throw new TableException("wrong columns count", "columns array is null or 0");
        }
        if (columns.length < this.columnCount) {
            throw new TableException("wrong columns array length", "columns array length must be the same as the columns used to initialise the table");
        }
        this.columnWidth = new Integer[columns.length + 1];
        this.columnWidth[0] = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null || columns[i] < 3) {
                throw new TableException("errors in columns array", "member " + i + " is either null or smaller than 3 (minimum cloumn width");
            }
            Integer[] integerArray = this.columnWidth;
            Integer.valueOf(integerArray[0] + columns[i]);
            this.columnWidth[i + 1] = columns[i];
        }
        Integer[] i = this.columnWidth;
        Integer.valueOf(i[0] + (columns.length + 1));
        this.borders = new boolean[this.columnCount + 1];
        for (int i2 = 0; i2 < this.columnCount + 1; ++i2) {
            this.borders[i2] = true;
        }
    }

    public TableRowRenderer setPaddingChar(char pChar) {
        this.paddingChar = pChar;
        return this;
    }

    public TableRowRenderer setTheme(ThemeSimple ts) {
        if (ts != null) {
            this.ts = ts;
            this.tb = null;
        }
        return this;
    }

    public TableRowRenderer setBorders(boolean[] borders) {
        if (borders != null && borders.length == this.borders.length) {
            this.borders = borders;
        }
        return this;
    }

    public TableRowRenderer setTheme(ThemeTB tb) {
        if (tb != null) {
            this.ts = null;
            this.tb = tb;
        }
        return this;
    }

    protected String[][] transformArray(Object[] columns) {
        String[][] ar = new String[this.columnCount][];
        for (int i = 0; i < columns.length; ++i) {
            Object o = columns[i];
            ar[i] = ArrayTransformations.WRAP_LINES(this.columnWidth[i + 1], o);
        }
        ar = ArrayTransformations.NORMALISE_ARRAY(this.columnCount, ar);
        ar = ArrayTransformations.FLIP_ARRAY(ar);
        return ar;
    }

    protected final void fixBottomRule(List<TableRow> table) {
        switch (table.get(table.size() - 1).getType()) {
            case MID_EMPH: {
                table.remove(table.size() - 1);
                table.add(TableRow.create(TableRowType.BOTTOM_EMPH));
                break;
            }
            case MID: {
                table.remove(table.size() - 1);
                table.add(TableRow.create(TableRowType.BOTTOM));
                break;
            }
            case CONTENT: {
                table.add(TableRow.create(TableRowType.BOTTOM));
            }
        }
    }

    protected final void fixTopRule(List<TableRow> table) {
        switch (table.get(0).getType()) {
            case MID_EMPH: {
                table.remove(0);
                table.add(0, TableRow.create(TableRowType.TOP_EMPH));
                break;
            }
            case MID: {
                table.remove(0);
                table.add(0, TableRow.create(TableRowType.TOP));
                break;
            }
            case CONTENT: {
                table.add(0, TableRow.create(TableRowType.TOP));
            }
        }
    }

    protected final void adjustColumns(List<TableRow> table) {
        for (TableRow row : table) {
            if (!row.getType().equals((Object)TableRowType.CONTENT)) continue;
            row.setAdjustedColumns(this.transformArray(row.getColumns()));
        }
    }

    protected final void adjustBordersContentRow(List<TableRow> table) {
        for (TableRow row : table) {
            if (!row.getType().equals((Object)TableRowType.CONTENT)) continue;
            AdjustedBorderType[] adjustedBorders = new AdjustedBorderType[this.columnCount + 1];
            if (this.borders[0]) {
                adjustedBorders[0] = AdjustedBorderType.CONTENT;
            }
            String[] ar = row.getAdjustedColumns()[0];
            for (int i = 0; i < ar.length; ++i) {
                String content = ar[i];
                if (content == null) {
                    if (i == ar.length - 1) {
                        adjustedBorders[i + 1] = AdjustedBorderType.NONE;
                        continue;
                    }
                    adjustedBorders[i + 1] = AdjustedBorderType.NONE;
                    continue;
                }
                if ("".equals(content)) {
                    if (!this.borders[i + 1]) continue;
                    adjustedBorders[i + 1] = AdjustedBorderType.CONTENT;
                    continue;
                }
                if (!this.borders[i + 1]) continue;
                adjustedBorders[i + 1] = AdjustedBorderType.CONTENT;
            }
            if (this.borders[this.columnCount]) {
                adjustedBorders[this.columnCount] = AdjustedBorderType.CONTENT;
            }
            row.setAdjustedBorders(adjustedBorders);
        }
    }

    protected final void adjustTopRuleBorder(List<TableRow> table) {
        switch (table.get(0).getType()) {
            case TOP: 
            case TOP_EMPH: {
                AdjustedBorderType[] relAdj;
                AdjustedBorderType[] adjustedBorders = new AdjustedBorderType[this.borders.length];
                for (int i = 0; i < adjustedBorders.length; ++i) {
                    adjustedBorders[i] = AdjustedBorderType.NONE;
                }
                if (table.size() > 1 && (relAdj = table.get(1).getAdjustedBorders()) != null) {
                    block11: for (int i = 0; i < relAdj.length; ++i) {
                        switch (relAdj[i]) {
                            case NONE: {
                                adjustedBorders[i] = AdjustedBorderType.NONE;
                                continue block11;
                            }
                            case UP: {
                                adjustedBorders[i] = AdjustedBorderType.DOWN;
                                continue block11;
                            }
                            case ALL: {
                                adjustedBorders[i] = AdjustedBorderType.DOWN;
                                continue block11;
                            }
                            case DOWN: {
                                adjustedBorders[i] = AdjustedBorderType.NONE;
                                continue block11;
                            }
                            case CONTENT: {
                                adjustedBorders[i] = AdjustedBorderType.DOWN;
                            }
                        }
                    }
                }
                table.get(0).setAdjustedBorders(adjustedBorders);
                break;
            }
        }
    }

    protected final void adjustBottomRuleBorder(List<TableRow> table) {
        switch (table.get(table.size() - 1).getType()) {
            case BOTTOM: 
            case BOTTOM_EMPH: {
                AdjustedBorderType[] relAdj;
                AdjustedBorderType[] adjustedBorders = new AdjustedBorderType[this.borders.length];
                for (int i = 0; i < adjustedBorders.length; ++i) {
                    adjustedBorders[i] = AdjustedBorderType.NONE;
                }
                if (table.size() > 1 && (relAdj = table.get(table.size() - 2).getAdjustedBorders()) != null) {
                    block11: for (int i = 0; i < relAdj.length; ++i) {
                        switch (relAdj[i]) {
                            case NONE: {
                                adjustedBorders[i] = AdjustedBorderType.NONE;
                                continue block11;
                            }
                            case UP: {
                                adjustedBorders[i] = AdjustedBorderType.NONE;
                                continue block11;
                            }
                            case ALL: {
                                adjustedBorders[i] = AdjustedBorderType.UP;
                                continue block11;
                            }
                            case DOWN: {
                                adjustedBorders[i] = AdjustedBorderType.UP;
                                continue block11;
                            }
                            case CONTENT: {
                                adjustedBorders[i] = AdjustedBorderType.UP;
                            }
                        }
                    }
                }
                table.get(table.size() - 1).setAdjustedBorders(adjustedBorders);
                break;
            }
        }
    }

    protected final void adjustAllRuleBorderAbove(List<TableRow> table) {
        if (table.size() > 2) {
            block10: for (int r = 1; r < table.size() - 1; ++r) {
                switch (table.get(r).getType()) {
                    case MID_EMPH: 
                    case MID: {
                        AdjustedBorderType[] adjustedBorders = new AdjustedBorderType[this.borders.length];
                        for (int i = 0; i < adjustedBorders.length; ++i) {
                            adjustedBorders[i] = AdjustedBorderType.NONE;
                        }
                        AdjustedBorderType[] relAdj = table.get(r - 1).getAdjustedBorders();
                        if (relAdj != null) {
                            block12: for (int i = 0; i < relAdj.length; ++i) {
                                switch (relAdj[i]) {
                                    case NONE: {
                                        adjustedBorders[i] = AdjustedBorderType.NONE;
                                        continue block12;
                                    }
                                    case UP: {
                                        adjustedBorders[i] = AdjustedBorderType.NONE;
                                        continue block12;
                                    }
                                    case ALL: {
                                        adjustedBorders[i] = AdjustedBorderType.UP;
                                        continue block12;
                                    }
                                    case DOWN: {
                                        adjustedBorders[i] = AdjustedBorderType.UP;
                                        continue block12;
                                    }
                                    case CONTENT: {
                                        adjustedBorders[i] = AdjustedBorderType.UP;
                                    }
                                }
                            }
                        }
                        table.get(r).setAdjustedBorders(adjustedBorders);
                        continue block10;
                    }
                }
            }
        }
    }

    protected final void adjustAllRuleBorderBelow(List<TableRow> table) {
        if (table.size() > 2) {
            block7: for (int r = 1; r < table.size() - 1; ++r) {
                switch (table.get(r).getType()) {
                    case MID_EMPH: 
                    case MID: {
                        AdjustedBorderType[] adjustedBorders = new AdjustedBorderType[this.borders.length];
                        for (int i = 0; i < adjustedBorders.length; ++i) {
                            adjustedBorders[i] = AdjustedBorderType.NONE;
                        }
                        AdjustedBorderType[] relAdj = table.get(r + 1).getAdjustedBorders();
                        if (relAdj != null) {
                            block9: for (int i = 0; i < relAdj.length; ++i) {
                                switch (relAdj[i]) {
                                    case NONE: 
                                    case DOWN: {
                                        continue block9;
                                    }
                                    case UP: 
                                    case ALL: 
                                    case CONTENT: {
                                        adjustedBorders[i] = table.get(r).getAdjustedBorders()[i] == AdjustedBorderType.UP ? AdjustedBorderType.ALL : AdjustedBorderType.DOWN;
                                    }
                                }
                            }
                        }
                        table.get(r).setAdjustedBorders(adjustedBorders);
                        continue block7;
                    }
                }
            }
        }
    }

    public final void prepareTable(List<TableRow> table) {
        this.fixTopRule(table);
        this.fixBottomRule(table);
        this.adjustColumns(table);
        this.adjustBordersContentRow(table);
        this.adjustTopRuleBorder(table);
        this.adjustBottomRuleBorder(table);
        this.adjustAllRuleBorderAbove(table);
        this.adjustAllRuleBorderBelow(table);
    }

    protected char getChar(BorderPosition pos, AdjustedBorderType type, ThemeRow tr) {
        switch (type) {
            case ALL: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
            case CONTENT: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderAll();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
            case DOWN: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderDown();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
            case NONE: {
                return tr.getMid();
            }
            case UP: {
                switch (pos) {
                    case LEFT: {
                        return tr.getLeftBorder();
                    }
                    case MIDDLE: {
                        return tr.getMidBorderUp();
                    }
                    case RIGHT: {
                        return tr.getRightBorder();
                    }
                }
            }
        }
        return 'X';
    }

    public StrBuilder renderRow(TableRow row) {
        StrBuilder ret = new StrBuilder(100);
        String[][] columns = row.getAdjustedColumns();
        AdjustedBorderType[] borders = row.getAdjustedBorders();
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                ThemeRow tr = this.ts.getContent();
                if (i != 0) {
                    ret.appendNewLine();
                }
                int span = 0;
                for (int k = 0; k < borders.length; ++k) {
                    if (borders[k] != AdjustedBorderType.NONE) {
                        if (k == 0) {
                            ret.append(this.getChar(BorderPosition.LEFT, borders[k], tr));
                        } else if (k == borders.length - 1) {
                            ret.append(this.getChar(BorderPosition.RIGHT, borders[k], tr));
                        } else {
                            ret.append(this.getChar(BorderPosition.MIDDLE, borders[k], tr));
                        }
                    }
                    if (k >= columns[i].length) continue;
                    if (ArrayUtils.contains((Object[])columns[i], null)) {
                        int s;
                        int width;
                        if (columns[i][k] == null) {
                            if (k == columns[i].length - 1) {
                                width = 0;
                                for (s = 0; s < span; ++s) {
                                    width += this.columnWidth[s + 1].intValue();
                                }
                                width += span;
                                ret.appendFixedWidthPadRight((Object)"", width += this.columnWidth[i + 1].intValue(), this.paddingChar);
                                continue;
                            }
                            ++span;
                            continue;
                        }
                        if ("".equals(columns[i][k])) {
                            for (int s2 = 0; s2 < span; ++s2) {
                                ret.appendFixedWidthPadRight((Object)"", this.columnWidth[s2 + 1].intValue(), this.paddingChar);
                            }
                            ret.appendFixedWidthPadRight((Object)"", span, this.paddingChar);
                            span = 0;
                            ret.appendFixedWidthPadRight((Object)columns[i][k], this.columnWidth[i + 1].intValue(), this.paddingChar);
                            continue;
                        }
                        width = 0;
                        for (s = 0; s < span; ++s) {
                            width += this.columnWidth[s + 1].intValue();
                        }
                        width += span;
                        ret.append(StringUtils.center((String)columns[i][k], (int)(width += this.columnWidth[i + 1].intValue()), (char)this.paddingChar));
                        span = 0;
                        continue;
                    }
                    ret.appendFixedWidthPadRight((Object)columns[i][k], this.columnWidth[i + 1].intValue(), this.paddingChar);
                }
            }
        } else {
            ThemeRow tr = null;
            tr = row.getType().equals((Object)TableRowType.TOP) ? this.ts.getTop() : (row.getType().equals((Object)TableRowType.BOTTOM) ? this.ts.getBottom() : this.ts.getMid());
            for (int k = 0; k < borders.length; ++k) {
                if (k == 0) {
                    ret.append(this.getChar(BorderPosition.LEFT, borders[k], tr));
                } else if (k == borders.length - 1) {
                    ret.append(this.getChar(BorderPosition.RIGHT, borders[k], tr));
                } else {
                    ret.append(this.getChar(BorderPosition.MIDDLE, borders[k], tr));
                }
                if (k + 1 >= this.columnWidth.length) continue;
                ret.appendPadding(this.columnWidth[k + 1].intValue(), tr.getMid());
            }
        }
        return ret;
    }

    public List<StrBuilder> render(List<TableRow> table) {
        this.prepareTable(table);
        LinkedList<StrBuilder> ret = new LinkedList<StrBuilder>();
        for (TableRow row : table) {
            ret.add(this.renderRow(row));
        }
        return ret;
    }

    protected static enum BorderPosition {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

