/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist.styles;

import de.vandermeer.asciilist.commons.AlphaLiteralUtils;
import de.vandermeer.asciilist.commons.ArabicLiteralUtils;
import de.vandermeer.asciilist.commons.RomanNumberLiterals;
import de.vandermeer.asciilist.styles.ListStyle_Enumerate;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.text.StrBuilder;

public enum EnumerateStyles implements ListStyle_Enumerate
{
    Alpha,
    Alpha_circle,
    Alpha_fullwidth,
    alpha,
    alpha_circle,
    alpha_parenthesized,
    alpha_fullwidth,
    arabic,
    arabic_circle,
    arabic_double_circle,
    arabic_circle_dingbat_negative,
    arabic_circle_dingbat_sanserif,
    arabic_circle_dingbat_negative_sanserif,
    arabic_superscript,
    arabic_subscript,
    arabic_full_stop,
    arabic_parenthesized,
    arabic_fullwidth,
    Roman,
    Roman_circled,
    Roman_number_forms,
    roman,
    roman_circled,
    roman_number_forms;


    @Override
    public String getLabel(int position) {
        switch (this) {
            case Alpha: {
                return AlphaLiteralUtils.toAscii(position);
            }
            case Alpha_circle: {
                return AlphaLiteralUtils.toCircledLatinCapital(position);
            }
            case Alpha_fullwidth: {
                return AlphaLiteralUtils.toFullwidthLatinCapital(position);
            }
            case alpha: {
                return AlphaLiteralUtils.toAsciiLC(position);
            }
            case alpha_circle: {
                return AlphaLiteralUtils.toCircledLatinSmall(position);
            }
            case alpha_parenthesized: {
                return AlphaLiteralUtils.toParenthesizedLatinSmallLetter(position);
            }
            case alpha_fullwidth: {
                return AlphaLiteralUtils.toFullwidthLatinSmall(position);
            }
            case arabic: {
                return ArabicLiteralUtils.toAscii(position);
            }
            case arabic_circle: {
                return ArabicLiteralUtils.toCircledDigit(position);
            }
            case arabic_double_circle: {
                return ArabicLiteralUtils.toDoubleCircledDigit(position);
            }
            case arabic_circle_dingbat_negative: {
                return ArabicLiteralUtils.toDingbatNegativeCircledDigit(position);
            }
            case arabic_circle_dingbat_sanserif: {
                return ArabicLiteralUtils.toDingbatSanserifCircledDigit(position);
            }
            case arabic_circle_dingbat_negative_sanserif: {
                return ArabicLiteralUtils.toDingbatNegativeSanserifCircledDigit(position);
            }
            case arabic_superscript: {
                return ArabicLiteralUtils.toSuperscript(position);
            }
            case arabic_subscript: {
                return ArabicLiteralUtils.toSubscript(position);
            }
            case arabic_full_stop: {
                return ArabicLiteralUtils.toFullStop(position);
            }
            case arabic_parenthesized: {
                return ArabicLiteralUtils.toParenthesized(position);
            }
            case arabic_fullwidth: {
                return ArabicLiteralUtils.toFullwidth(position);
            }
            case Roman: {
                return RomanNumberLiterals.toAscii(position);
            }
            case Roman_circled: {
                return RomanNumberLiterals.toCircledLatinCaptial(position);
            }
            case Roman_number_forms: {
                return RomanNumberLiterals.toNumberForms(position);
            }
            case roman: {
                return RomanNumberLiterals.toAsciiLC(position);
            }
            case roman_circled: {
                return RomanNumberLiterals.toCircledLatinSmall(position);
            }
            case roman_number_forms: {
                return RomanNumberLiterals.toNumberFormsLC(position);
            }
        }
        throw new NotImplementedException("error in implementation, enum case not handled");
    }

    @Override
    public StrBuilder toDoc() {
        StrBuilder ret = new StrBuilder(30);
        ret.append(this.getLabel(1)).append(" item 1").appendNewLine();
        ret.append(this.getLabel(2)).append(" item 2").appendNewLine();
        ret.append(this.getLabel(3)).append(" item 3").appendNewLine();
        return ret;
    }
}

