/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist.styles;

import de.vandermeer.asciilist.styles.ListStyle_Check;
import org.apache.commons.lang3.text.StrBuilder;

public enum CheckListStyles implements ListStyle_Check
{
    SQUARE_BRACKET_BLANK_X("[", " ", "X", "]"),
    UTF_BALLOT_BOX("", "\u2610", "\u2611", ""),
    UTF_BALLOT_BOX_X("", "\u2610", "\u2612", ""),
    UTF_BALLOT_X("", " ", "\u2717", ""),
    UTF_BALLOT_X_HEAVY("", " ", "\u2718", ""),
    UTF_CHECKMARK("", " ", "\u2713", ""),
    UTF_MULTIPLICATION_X("", " ", "\u2715", "");

    String left;
    String right;
    String checked;
    String unchecked;

    private CheckListStyles(String left, String unchecked, String checked, String right) {
        this.left = left;
        this.unchecked = unchecked;
        this.checked = checked;
        this.right = right;
    }

    @Override
    public String getLabelChecked() {
        return this.left + this.checked + this.right;
    }

    @Override
    public String getLabelUnchecked() {
        return this.left + this.unchecked + this.right;
    }

    @Override
    public StrBuilder toDoc() {
        StrBuilder ret = new StrBuilder(30);
        ret.append(this.getLabelUnchecked()).append(" unchecked item").appendNewLine();
        ret.append(this.getLabelChecked()).append(" checked item").appendNewLine();
        return ret;
    }
}

