/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AbstractAsciiList;
import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciilist.AsciiList_Enumerate;
import de.vandermeer.asciilist.styles.ListStyle;
import de.vandermeer.asciilist.styles.ListStyle_EnumerateNested;
import de.vandermeer.asciilist.styles.NestedEnumerateStyles;
import org.apache.commons.lang3.ArrayUtils;

public class EnumerateList
extends AbstractAsciiList
implements AsciiList_Enumerate {
    protected ListStyle_EnumerateNested style;
    protected int[] parents;
    protected int realPosition = 0;
    protected String labelSeparator;
    protected boolean useLabelSeparatorAfterLastItem;

    public EnumerateList() {
        this(true);
    }

    public EnumerateList(boolean isContinued) {
        super(isContinued);
        this.style = NestedEnumerateStyles.aLL_arabic;
        this.labelSeparator = ".";
        this.useLabelSeparatorAfterLastItem = false;
    }

    public EnumerateList(EnumerateList list) {
        super(list);
        this.style = list.style;
        this.realPosition = list.realPosition;
        this.useLabelSeparatorAfterLastItem = list.useLabelSeparatorAfterLastItem;
        this.labelSeparator = list.labelSeparator;
        this.parents = ArrayUtils.clone((int[])list.parents);
    }

    @Override
    public AsciiList addItem(AsciiList list) {
        AsciiList added = super.addItem(list);
        if (added instanceof AsciiList_Enumerate) {
            AsciiList_Enumerate addE = (AsciiList_Enumerate)added;
            if (addE.isContinuedList()) {
                ++this.realPosition;
                addE.setListStyle(this.style);
                addE.setLevel(this.level + 1);
                if (this.parents == null) {
                    addE.setParents(new int[]{this.items.size() - this.realPosition});
                } else {
                    addE.setParents(ArrayUtils.add((int[])this.parents, (int)(this.items.size() - this.realPosition)));
                }
            } else {
                addE.setLevel(1);
            }
        }
        return added;
    }

    @Override
    public String renderItem(AsciiListItem item, int position) {
        String label = this.style.getStyle(this.level).getLabel(position);
        if (this.parents != null) {
            label = "";
            for (int i = 0; i < this.parents.length; ++i) {
                label = label + this.style.getStyle(i + 1).getLabel(this.parents[i]) + this.labelSeparator;
            }
            label = label + this.style.getStyle(this.level).getLabel(position);
        }
        if (this.useLabelSeparatorAfterLastItem) {
            label = label + this.labelSeparator;
        }
        return item.render(this.preLabelIndent, this.preLabelStr, label, this.postLabelStr, this.postLabelIndent);
    }

    @Override
    public AsciiList_Enumerate setParents(int[] parents) {
        this.parents = parents;
        return this;
    }

    @Override
    public int[] getParents() {
        return this.parents;
    }

    @Override
    public AsciiList setListStyle(ListStyle style) {
        if (style instanceof ListStyle_EnumerateNested) {
            this.style = (ListStyle_EnumerateNested)style;
        }
        return super.setListStyle(style);
    }

    @Override
    public AsciiList copy() {
        return new EnumerateList(this);
    }

    @Override
    public AsciiList_Enumerate setLabelSeparator(String separator) {
        this.labelSeparator = separator;
        return this;
    }

    @Override
    public String getLabelSeparator() {
        return this.labelSeparator;
    }

    @Override
    public AsciiList_Enumerate useLabelSeparatorAfterLastItem(boolean flag) {
        this.useLabelSeparatorAfterLastItem = flag;
        return this;
    }
}

