/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AbstractAsciiList;
import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciilist.AsciiList_Check;
import de.vandermeer.asciilist.CheckListItem;
import de.vandermeer.asciilist.styles.ListStyle;
import de.vandermeer.asciilist.styles.ListStyle_CheckNested;
import de.vandermeer.asciilist.styles.NestedCheckStyles;
import org.apache.commons.lang3.StringUtils;

public class CheckList
extends AbstractAsciiList
implements AsciiList_Check {
    protected ListStyle_CheckNested style;

    public CheckList() {
        this(true);
    }

    public CheckList(boolean isContinued) {
        super(isContinued);
        this.style = NestedCheckStyles.ALL_SQUARE_BRACKET_BLANK_X;
    }

    public CheckList(CheckList list) {
        super(list);
        this.style = list.style;
    }

    @Override
    public CheckList addItem(String item) {
        if (!StringUtils.isBlank((CharSequence)item)) {
            this.items.add(new CheckListItem(item, false));
        }
        return this;
    }

    @Override
    public CheckList addItemChecked(String item) {
        if (!StringUtils.isBlank((CharSequence)item)) {
            this.items.add(new CheckListItem(item, true));
        }
        return this;
    }

    @Override
    public AsciiList addItem(AsciiList list) {
        AsciiList added = super.addItem(list);
        if (added instanceof AsciiList_Check) {
            AsciiList_Check addC = (AsciiList_Check)added;
            if (addC.isContinuedList()) {
                addC.setListStyle(this.style);
                addC.setLevel(this.level + 1);
            } else {
                addC.setLevel(1);
            }
        }
        return added;
    }

    @Override
    public AsciiList_Check setPreLabel(String preLabel) {
        if (!StringUtils.isBlank((CharSequence)preLabel)) {
            this.preLabelStr = preLabel;
        }
        return this;
    }

    @Override
    public AsciiList_Check setPostLabel(String postLabel) {
        if (!StringUtils.isBlank((CharSequence)postLabel)) {
            this.postLabelStr = postLabel;
        }
        return this;
    }

    @Override
    public AsciiList_Check setPostIndent(int indent) {
        if (indent >= 0) {
            this.postLabelIndent = indent;
        }
        return this;
    }

    @Override
    public String renderItem(AsciiListItem item, int position) {
        String label = this.style.getStyle(this.level).getLabelUnchecked();
        if (item instanceof CheckListItem && ((CheckListItem)item).isChecked()) {
            label = this.style.getStyle(this.level).getLabelChecked();
        }
        return item.render(this.preLabelIndent, this.preLabelStr, label, this.postLabelStr, this.postLabelIndent);
    }

    @Override
    public AsciiList setListStyle(ListStyle style) {
        if (style instanceof ListStyle_CheckNested) {
            this.style = (ListStyle_CheckNested)style;
        }
        return super.setListStyle(style);
    }

    @Override
    public AsciiList copy() {
        return new CheckList(this);
    }
}

