/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AbstractAsciiListItem;
import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListItem;
import de.vandermeer.asciilist.styles.ListStyle;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;

public abstract class AbstractAsciiList
implements AsciiList {
    protected List<Object> items = new ArrayList<Object>();
    protected int preLabelIndent = 1;
    protected int postLabelIndent = 1;
    protected String preLabelStr = "";
    protected String postLabelStr = "";
    protected int level = 1;
    protected final boolean isContinued;

    public AbstractAsciiList() {
        this(true);
    }

    public AbstractAsciiList(boolean isContinued) {
        this.isContinued = isContinued;
    }

    public AbstractAsciiList(AbstractAsciiList list) {
        this(list.isContinued);
        this.preLabelIndent = list.preLabelIndent;
        this.postLabelIndent = list.postLabelIndent;
        this.preLabelStr = list.preLabelStr;
        this.postLabelStr = list.postLabelStr;
        this.level = list.level;
        this.items.addAll(list.items);
    }

    @Override
    public AsciiList addItem(AsciiList list) {
        Validate.notEmpty(list.getItems());
        AsciiList add = list.copy();
        this.items.add(add);
        return add;
    }

    @Override
    public AsciiList addItem(String item) {
        if (!StringUtils.isBlank((CharSequence)item)) {
            this.items.add(new AbstractAsciiListItem(item));
        }
        return this;
    }

    @Override
    public List<Object> getItems() {
        return this.items;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String render() {
        StrBuilder ret = new StrBuilder(100);
        int position = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) instanceof AsciiListItem) {
                ret.appendSeparator("\n").append(this.renderItem((AsciiListItem)this.items.get(i), ++position));
                continue;
            }
            if (this.items.get(i) instanceof AsciiList) {
                AsciiList l = (AsciiList)this.items.get(i);
                int indent = this.preLabelIndent + this.postLabelIndent + 1 + this.preLabelStr.length() + this.postLabelStr.length();
                l.setPreLabelIndent(indent);
                ret.appendSeparator("\n").append(l.render());
                continue;
            }
            throw new NotImplementedException("not yet implemented, only AsciiListItem supported");
        }
        return ret.toString();
    }

    @Override
    public AsciiList setLevel(int level) {
        if (level > 1) {
            this.level = level;
        }
        return this;
    }

    @Override
    public AsciiList setListStyle(ListStyle style) {
        for (Object obj : this.items) {
            if (!(obj instanceof AsciiList)) continue;
            ((AsciiList)obj).setListStyle(style);
        }
        return this;
    }

    @Override
    public AsciiList setPreLabelIndent(int indent) {
        if (indent > -1) {
            this.preLabelIndent = indent;
        }
        return this;
    }

    @Override
    public AsciiList setPreLabelString(String str) {
        this.preLabelStr = str;
        return this;
    }

    @Override
    public AsciiList setPostLabelString(String str) {
        this.postLabelStr = str;
        return this;
    }

    @Override
    public AsciiList setPostLabelIndent(int indent) {
        if (indent > -1) {
            this.postLabelIndent = indent;
        }
        return this;
    }

    @Override
    public int getPreLabelIndent() {
        return this.preLabelIndent;
    }

    @Override
    public String getPreLabelString() {
        return this.preLabelStr;
    }

    @Override
    public String getPostLabelString() {
        return this.postLabelStr;
    }

    @Override
    public int getPostLabelIndent() {
        return this.postLabelIndent;
    }

    @Override
    public boolean isContinuedList() {
        return this.isContinued;
    }
}

