/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.script;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8RuntimeException;
import com.eclipsesource.v8.V8Value;
import de.undercouch.citeproc.AbbreviationProvider;
import de.undercouch.citeproc.ItemDataProvider;
import de.undercouch.citeproc.LocaleProvider;
import de.undercouch.citeproc.VariableWrapper;
import de.undercouch.citeproc.VariableWrapperParams;
import de.undercouch.citeproc.csl.CSLAbbreviationList;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import de.undercouch.citeproc.helper.json.StringJsonBuilder;
import de.undercouch.citeproc.script.AbstractScriptRunner;
import de.undercouch.citeproc.script.ScriptRunnerException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class V8ScriptRunner
extends AbstractScriptRunner {
    private final V8 runtime = V8.createV8Runtime();

    @Override
    public String getName() {
        return "V8";
    }

    @Override
    public String getVersion() {
        return String.valueOf(this.runtime.getBuildID());
    }

    @Override
    public void eval(Reader reader) throws IOException {
        int read;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[10240];
        while ((read = reader.read(buf)) >= 0) {
            sb.append(buf, 0, read);
        }
        this.runtime.executeVoidScript(sb.toString());
    }

    @Override
    public <T> T callMethod(String name, Class<T> resultType, Object ... args) throws ScriptRunnerException {
        HashSet<V8Value> newValues = new HashSet<V8Value>();
        V8Array parameters = this.convertArguments(args, newValues);
        try {
            if (String.class.isAssignableFrom(resultType)) {
                String string = this.runtime.executeStringFunction(name, parameters);
                return (T)string;
            }
            T t = this.convert(this.runtime.executeObjectFunction(name, parameters), resultType);
            return t;
        }
        catch (V8RuntimeException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
        finally {
            newValues.forEach(V8Value::release);
        }
    }

    @Override
    public void callMethod(String name, Object ... args) throws ScriptRunnerException {
        HashSet<V8Value> newValues = new HashSet<V8Value>();
        V8Array parameters = this.convertArguments(args, newValues);
        try {
            this.runtime.executeVoidFunction(name, parameters);
        }
        catch (V8RuntimeException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
        finally {
            newValues.forEach(V8Value::release);
        }
    }

    @Override
    public <T> T callMethod(Object obj, String name, Class<T> resultType, Object ... args) throws ScriptRunnerException {
        HashSet<V8Value> newValues = new HashSet<V8Value>();
        V8Array parameters = this.convertArguments(args, newValues);
        try {
            V8Object vo = (V8Object)obj;
            if (String.class.isAssignableFrom(resultType)) {
                String string = vo.executeStringFunction(name, parameters);
                return (T)string;
            }
            T t = this.convert(vo.executeObjectFunction(name, parameters), resultType);
            return t;
        }
        catch (V8RuntimeException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
        finally {
            newValues.forEach(V8Value::release);
        }
    }

    @Override
    public void callMethod(Object obj, String name, Object ... args) throws ScriptRunnerException {
        HashSet<V8Value> newValues = new HashSet<V8Value>();
        V8Array parameters = this.convertArguments(args, newValues);
        try {
            ((V8Object)obj).executeVoidFunction(name, parameters);
        }
        catch (V8RuntimeException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
        finally {
            newValues.forEach(V8Value::release);
        }
    }

    @Override
    public <T> T convert(Object r, Class<T> resultType) {
        if (List.class.isAssignableFrom(resultType) && r instanceof V8Array) {
            V8Array arr = (V8Array)r;
            r = this.convertArray(arr);
            arr.release();
        } else if (Map.class.isAssignableFrom(resultType) && r instanceof V8Object) {
            V8Object obj = (V8Object)r;
            r = this.convertObject(obj);
            obj.release();
        }
        return (T)r;
    }

    private List<Object> convertArray(V8Array arr) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < arr.length(); ++i) {
            Object o = arr.get(i);
            if (o instanceof V8Array) {
                o = this.convert(o, List.class);
            } else if (o instanceof V8Object) {
                o = this.convert(o, Map.class);
            }
            l.add(o);
        }
        return l;
    }

    private Map<String, Object> convertObject(V8Object obj) {
        if (obj.isUndefined()) {
            return null;
        }
        LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>();
        for (String k : obj.getKeys()) {
            Object o = obj.get(k);
            if (o instanceof V8Array) {
                o = this.convert(o, List.class);
            } else if (o instanceof V8Object) {
                o = this.convert(o, Map.class);
            }
            r.put(k, o);
        }
        return r;
    }

    @Override
    public JsonBuilder createJsonBuilder() {
        return new StringJsonBuilder(this);
    }

    private V8Array convertArguments(Object[] args, Set<V8Value> newValues) {
        V8Array result = new V8Array(this.runtime);
        newValues.add((V8Value)result);
        for (Object o : args) {
            V8Object v8o;
            V8Object v;
            if (o == null) {
                result.push(0);
                continue;
            }
            if (o instanceof JsonObject || o instanceof Collection || o.getClass().isArray() || o instanceof Map) {
                v = this.runtime.executeObjectScript("(" + this.createJsonBuilder().toJson(o).toString() + ")");
                newValues.add((V8Value)v);
                result.push((V8Value)v);
                continue;
            }
            if (o instanceof String) {
                result.push((String)o);
                continue;
            }
            if (o instanceof Integer) {
                result.push(((Integer)o).intValue());
                continue;
            }
            if (o instanceof Boolean) {
                result.push(((Boolean)o).booleanValue());
                continue;
            }
            if (o instanceof Double) {
                result.push(((Double)o).doubleValue());
                continue;
            }
            if (o instanceof ItemDataProvider) {
                o = new ItemDataProviderWrapper((ItemDataProvider)o);
                v8o = this.convertJavaObject(o);
                newValues.add((V8Value)v8o);
                result.push((V8Value)v8o);
                continue;
            }
            if (o instanceof AbbreviationProvider) {
                o = new AbbreviationProviderWrapper((AbbreviationProvider)o);
                v8o = this.convertJavaObject(o);
                newValues.add((V8Value)v8o);
                result.push((V8Value)v8o);
                continue;
            }
            if (o instanceof VariableWrapper) {
                o = new VariableWrapperWrapper((VariableWrapper)o);
                v8o = this.convertJavaObject(o);
                newValues.add((V8Value)v8o);
                result.push((V8Value)v8o);
                continue;
            }
            if (o instanceof V8ScriptRunner || o instanceof LocaleProvider) {
                v8o = this.convertJavaObject(o);
                newValues.add((V8Value)v8o);
                result.push((V8Value)v8o);
                continue;
            }
            if (o instanceof V8Value) {
                v = (V8Value)o;
                result.push((V8Value)v);
                continue;
            }
            throw new IllegalArgumentException("Unsupported argument: " + o.getClass());
        }
        return result;
    }

    private V8Object convertJavaObject(Object o) {
        Method[] methods;
        V8Object v8o = new V8Object(this.runtime);
        for (Method m : methods = o.getClass().getMethods()) {
            v8o.registerJavaMethod(o, m.getName(), m.getName(), (Class[])m.getParameterTypes());
        }
        return v8o;
    }

    @Override
    public void close() {
        this.runtime.release(true);
    }

    @Override
    public void release(Object o) {
        if (o instanceof V8Object) {
            ((V8Object)o).release();
        }
    }

    private class VariableWrapperWrapper {
        private final VariableWrapper wrapper;

        public VariableWrapperWrapper(VariableWrapper wrapper) {
            this.wrapper = wrapper;
        }

        public String wrap(Object params, String prePunct, String str, String postPunct) {
            Map m = V8ScriptRunner.this.convertObject((V8Object)params);
            VariableWrapperParams p = VariableWrapperParams.fromJson(m);
            return this.wrapper.wrap(p, prePunct, str, postPunct);
        }
    }

    private class AbbreviationProviderWrapper {
        private final AbbreviationProvider provider;

        public AbbreviationProviderWrapper(AbbreviationProvider provider) {
            this.provider = provider;
        }

        public Object getAbbreviations(String name) {
            CSLAbbreviationList a = this.provider.getAbbreviations(name);
            if (a == null) {
                return null;
            }
            return a.toJson(V8ScriptRunner.this.createJsonBuilder());
        }
    }

    private class ItemDataProviderWrapper {
        private final ItemDataProvider provider;

        public ItemDataProviderWrapper(ItemDataProvider provider) {
            this.provider = provider;
        }

        public Object retrieveItem(String id) {
            CSLItemData item = this.provider.retrieveItem(id);
            if (item == null) {
                return null;
            }
            return item.toJson(V8ScriptRunner.this.createJsonBuilder());
        }
    }
}

