/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.script;

import de.undercouch.citeproc.VariableWrapper;
import de.undercouch.citeproc.VariableWrapperParams;
import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonObject;
import de.undercouch.citeproc.helper.json.StringJsonBuilder;
import de.undercouch.citeproc.script.AbstractScriptRunner;
import de.undercouch.citeproc.script.ScriptRunnerException;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;

public class GraalScriptRunner
extends AbstractScriptRunner {
    private Context ctx = Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(true).build();

    @Override
    public String getName() {
        return this.ctx.getEngine().getImplementationName();
    }

    @Override
    public String getVersion() {
        return this.ctx.getEngine().getVersion();
    }

    @Override
    public void eval(Reader reader) throws IOException {
        this.ctx.eval(Source.newBuilder((String)"js", (Reader)reader, null).cached(false).build());
    }

    @Override
    public <T> T callMethod(String name, Class<T> resultType, Object ... args) throws ScriptRunnerException {
        try {
            return this.convert(this.ctx.getBindings("js").getMember(name).execute(this.convertArguments(args)), resultType);
        }
        catch (IOException | PolyglotException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }

    @Override
    public void callMethod(String name, Object ... args) throws ScriptRunnerException {
        try {
            this.ctx.getBindings("js").getMember(name).executeVoid(this.convertArguments(args));
        }
        catch (IOException | PolyglotException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }

    @Override
    public <T> T callMethod(Object obj, String name, Class<T> resultType, Object ... args) throws ScriptRunnerException {
        try {
            return this.convert(((Value)obj).getMember(name).execute(this.convertArguments(args)), resultType);
        }
        catch (IOException | PolyglotException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }

    @Override
    public void callMethod(Object obj, String name, Object ... args) throws ScriptRunnerException {
        try {
            ((Value)obj).getMember(name).executeVoid(this.convertArguments(args));
        }
        catch (IOException | PolyglotException e) {
            throw new ScriptRunnerException("Could not call method", e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object convert(Value v) {
        void var1_18;
        Value value = v;
        if (v.isNull()) {
            return var1_18;
        }
        if (v.isBoolean()) {
            Boolean bl = v.asBoolean();
            return var1_18;
        } else if (v.isDate()) {
            LocalDate localDate = v.asDate();
            return var1_18;
        } else if (v.isDuration()) {
            Duration duration = v.asDuration();
            return var1_18;
        } else if (v.isHostObject()) {
            Object object = v.asHostObject();
            return var1_18;
        } else if (v.isInstant()) {
            Instant instant = v.asInstant();
            return var1_18;
        } else if (v.isNativePointer()) {
            Long l = v.asNativePointer();
            return var1_18;
        } else if (v.isNumber()) {
            if (v.fitsInInt()) {
                Integer n = v.asInt();
                return var1_18;
            } else if (v.fitsInLong()) {
                Long l = v.asLong();
                return var1_18;
            } else {
                if (!v.fitsInDouble()) throw new IllegalStateException("Unknown type of number");
                Double d = v.asDouble();
            }
            return var1_18;
        } else if (v.isProxyObject()) {
            Proxy proxy = v.asProxyObject();
            return var1_18;
        } else if (v.isString()) {
            String string = v.asString();
            return var1_18;
        } else if (v.isTime()) {
            LocalTime localTime = v.asTime();
            return var1_18;
        } else if (v.isTimeZone()) {
            ZoneId zoneId = v.asTimeZone();
            return var1_18;
        } else if (v.hasArrayElements()) {
            List<Object> list = GraalScriptRunner.convertArray(v);
            return var1_18;
        } else {
            if (!v.hasMembers()) return var1_18;
            Map<String, Object> map = GraalScriptRunner.convertObject(v);
        }
        return var1_18;
    }

    @Override
    public <T> T convert(Object o, Class<T> type) {
        if (type != Object.class && o instanceof Value) {
            o = GraalScriptRunner.convert((Value)o);
        }
        return (T)o;
    }

    private static List<Object> convertArray(Value arr) {
        ArrayList<Object> l = new ArrayList<Object>();
        int i = 0;
        while ((long)i < arr.getArraySize()) {
            Value v = arr.getArrayElement((long)i);
            Object o = GraalScriptRunner.convert(v);
            l.add(o);
            ++i;
        }
        return l;
    }

    private static Map<String, Object> convertObject(Value obj) {
        LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>();
        for (String k : obj.getMemberKeys()) {
            Value v = obj.getMember(k);
            Object o = GraalScriptRunner.convert(v);
            r.put(k, o);
        }
        return r;
    }

    private Object[] convertArguments(Object[] args) throws IOException {
        Object[] copy = args;
        for (int i = 0; i < args.length; ++i) {
            Object v;
            Object o = v = args[i];
            if (v instanceof JsonObject || v instanceof Collection || v != null && v.getClass().isArray() || v instanceof Map) {
                String so = this.createJsonBuilder().toJson(v).toString();
                Source src = Source.newBuilder((String)"js", (CharSequence)("(" + so + ")"), (String)"parseMyJSON").cached(false).build();
                o = this.ctx.eval(src);
            } else if (v instanceof VariableWrapper) {
                o = new VariableWrapperWrapper((VariableWrapper)o);
            }
            if (o == v) continue;
            if (copy == args) {
                copy = Arrays.copyOf(args, args.length);
            }
            copy[i] = o;
        }
        return copy;
    }

    @Override
    public void release(Object o) {
    }

    @Override
    public JsonBuilder createJsonBuilder() {
        return new StringJsonBuilder(this);
    }

    @Override
    public void close() {
        this.ctx.close();
    }

    public static class VariableWrapperWrapper {
        private final VariableWrapper wrapper;

        private VariableWrapperWrapper(VariableWrapper wrapper) {
            this.wrapper = wrapper;
        }

        public String wrap(Value params, String prePunct, String str, String postPunct) {
            Map m = GraalScriptRunner.convertObject(params);
            VariableWrapperParams p = VariableWrapperParams.fromJson(m);
            return this.wrapper.wrap(p, prePunct, str, postPunct);
        }
    }
}

