/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import de.undercouch.bson4jackson.BsonParser;
import java.io.IOException;
import java.util.Date;

public class BsonDateDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 9) {
                throw ctxt.mappingException(Date.class);
            }
            return (Date)bsonParser.getEmbeddedObject();
        }
        return new Date(jp.getLongValue());
    }
}

