/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.io;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class StaticBuffers {
    public static final int GLOBAL_MIN_SIZE = 65536;
    private static final ThreadLocal<SoftReference<StaticBuffers>> _instance = new ThreadLocal();
    private ByteBuffer[] _byteBuffers = new ByteBuffer[Key.values().length];
    private CharBuffer[] _charBuffers = new CharBuffer[Key.values().length];

    private StaticBuffers() {
    }

    public static StaticBuffers getInstance() {
        StaticBuffers staticBuffers;
        SoftReference<StaticBuffers> softReference = _instance.get();
        StaticBuffers staticBuffers2 = staticBuffers = softReference == null ? null : softReference.get();
        if (staticBuffers == null) {
            staticBuffers = new StaticBuffers();
            _instance.set(new SoftReference<StaticBuffers>(staticBuffers));
        }
        return staticBuffers;
    }

    public CharBuffer charBuffer(Key key, int n) {
        n = Math.max(n, 65536);
        CharBuffer charBuffer = this._charBuffers[key.ordinal()];
        if (charBuffer == null || charBuffer.capacity() < n) {
            charBuffer = CharBuffer.allocate(n);
        } else {
            this._charBuffers[key.ordinal()] = null;
            charBuffer.clear();
        }
        return charBuffer;
    }

    public void releaseCharBuffer(Key key, CharBuffer charBuffer) {
        this._charBuffers[key.ordinal()] = charBuffer;
    }

    public ByteBuffer byteBuffer(Key key, int n) {
        n = Math.max(n, 65536);
        ByteBuffer byteBuffer = this._byteBuffers[key.ordinal()];
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(n);
        } else {
            this._byteBuffers[key.ordinal()] = null;
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    public void releaseByteBuffer(Key key, ByteBuffer byteBuffer) {
        this._byteBuffers[key.ordinal()] = byteBuffer;
    }

    public static enum Key {
        BUFFER0,
        BUFFER1,
        BUFFER2,
        BUFFER3,
        BUFFER4,
        BUFFER5,
        BUFFER6,
        BUFFER7,
        BUFFER8,
        BUFFER9;

    }
}

