/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.io;

import de.undercouch.bson4jackson.io.StaticBuffers;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class LittleEndianInputStream
extends FilterInputStream
implements DataInput {
    private static final StaticBuffers.Key UTF8_BUFFER = StaticBuffers.Key.BUFFER0;
    private byte[] _rawBuf = new byte[8];
    private ByteBuffer _buf = ByteBuffer.wrap(this._rawBuf).order(ByteOrder.LITTLE_ENDIAN);
    private CharBuffer _lineBuffer;
    private final StaticBuffers _staticBuffers = StaticBuffers.getInstance();
    private static Charset _utf8;
    private static CharsetDecoder _utf8Decoder;

    public LittleEndianInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private static Charset getUTF8Charset() {
        if (_utf8 == null) {
            _utf8 = Charset.forName("UTF-8");
        }
        return _utf8;
    }

    private static CharsetDecoder getUTF8Decoder() {
        if (_utf8Decoder == null) {
            _utf8Decoder = LittleEndianInputStream.getUTF8Charset().newDecoder();
        }
        return _utf8Decoder;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 -= n3;
            n += n3;
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long l;
        int n2 = 0;
        while (n > 0 && (l = this.skip(n)) > 0L) {
            n2 = (int)((long)n2 + l);
            n = (int)((long)n - l);
        }
        return n2;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return n + (n2 << 8);
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this._rawBuf, 0, 4);
        return this._buf.getInt(0);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this._rawBuf, 0, 8);
        return this._buf.getLong(0);
    }

    @Override
    public float readFloat() throws IOException {
        this.readFully(this._rawBuf, 0, 4);
        return this._buf.getFloat(0);
    }

    @Override
    public double readDouble() throws IOException {
        this.readFully(this._rawBuf, 0, 8);
        return this._buf.getDouble(0);
    }

    @Override
    public String readLine() throws IOException {
        int n;
        int n2 = 0;
        if (this._lineBuffer != null) {
            this._lineBuffer.rewind();
            this._lineBuffer.limit(this._lineBuffer.capacity());
            n2 = this._lineBuffer.capacity();
        }
        while ((n = this.read()) >= 0 && n != 10) {
            int n3;
            if (n == 13) {
                n3 = this.read();
                if (n3 == -1 || n3 == 10) break;
                if (!(this.in instanceof PushbackInputStream)) {
                    this.in = new PushbackInputStream(this.in);
                }
                ((PushbackInputStream)this.in).unread(n3);
                break;
            }
            if (this._lineBuffer == null || this._lineBuffer.remaining() == 0) {
                n3 = n2 + 128;
                CharBuffer charBuffer = CharBuffer.allocate(n3);
                if (this._lineBuffer != null) {
                    this._lineBuffer.flip();
                    charBuffer.put(this._lineBuffer);
                }
                this._lineBuffer = charBuffer;
                n2 = n3;
            }
            this._lineBuffer.put((char)n);
        }
        if (n < 0 && (this._lineBuffer == null || this._lineBuffer.position() == 0)) {
            return null;
        }
        return String.valueOf(this._lineBuffer.array(), 0, this._lineBuffer.position());
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readUTF(int n) throws IOException {
        return this.readUTF(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readUTF(DataInput dataInput, int n) throws IOException {
        ByteBuffer byteBuffer = this._staticBuffers.byteBuffer(UTF8_BUFFER, 8192);
        byte[] byArray = byteBuffer.array();
        CharsetDecoder charsetDecoder = LittleEndianInputStream.getUTF8Decoder();
        int n2 = n > 0 ? (int)(charsetDecoder.averageCharsPerByte() * (float)n) + 1 : 1024;
        CharBuffer charBuffer = this._staticBuffers.charBuffer(UTF8_BUFFER, n2);
        try {
            while (n != 0 || byteBuffer.position() > 0) {
                if (n < 0) {
                    while (byteBuffer.remaining() > 0) {
                        byte by = dataInput.readByte();
                        if (by == 0) {
                            n = 0;
                            break;
                        }
                        byteBuffer.put(by);
                    }
                    byteBuffer.flip();
                } else if (n > 0) {
                    int n3 = Math.min(n, byteBuffer.remaining());
                    dataInput.readFully(byArray, byteBuffer.position(), n3);
                    n -= n3;
                    byteBuffer.limit(n3);
                    byteBuffer.rewind();
                } else {
                    byteBuffer.flip();
                }
                CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, n == 0);
                if (coderResult.isUnderflow()) {
                    byteBuffer.compact();
                    continue;
                }
                if (coderResult.isOverflow()) {
                    byteBuffer.compact();
                    CharBuffer charBuffer2 = this._staticBuffers.charBuffer(UTF8_BUFFER, charBuffer.capacity() + 1024);
                    charBuffer.flip();
                    charBuffer2.put(charBuffer);
                    charBuffer = charBuffer2;
                    continue;
                }
                if (!coderResult.isError()) continue;
                coderResult.throwException();
            }
        }
        finally {
            this._staticBuffers.releaseCharBuffer(UTF8_BUFFER, charBuffer);
            this._staticBuffers.releaseByteBuffer(UTF8_BUFFER, byteBuffer);
        }
        charBuffer.flip();
        return charBuffer.toString();
    }
}

