/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.apiguardian.api.API;
import org.opentest4j.AssertionFailedError;

@API(status=API.Status.STABLE)
public final class ReflectionTestUtils {
    private static final String COULD_NOT_FIND_THE_METHOD = "Could not find the method ";
    private static final String BECAUSE = " because";
    private static final String THE_CONSTRUCTOR_WITH = " the constructor with ";

    private ReflectionTestUtils() {
    }

    public static Class<?> getClazz(String qualifiedClassName) {
        String[] qualifiedClassNameSegments = qualifiedClassName.split("\\.");
        String className = qualifiedClassNameSegments[qualifiedClassNameSegments.length - 1];
        try {
            return Class.forName(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw ReflectionTestUtils.failure("The class '" + className + "' was not found within the submission. Make sure to implement it properly.");
        }
        catch (ExceptionInInitializerError e) {
            throw ReflectionTestUtils.failure("The class '" + className + "' could not be initialized because an exception was thrown in a static initializer block. Make sure to implement the static initialization without errors.");
        }
    }

    public static Object newInstance(String qualifiedClassName, Object ... constructorArgs) {
        return ReflectionTestUtils.newInstance(ReflectionTestUtils.getClazz(qualifiedClassName), constructorArgs);
    }

    public static Object newInstance(Class<?> clazz, Object ... constructorArgs) {
        String failMessage = "Could not instantiate the class " + clazz.getSimpleName() + BECAUSE;
        Class<?>[] constructorArgTypes = ReflectionTestUtils.getParameterTypes(failMessage + " a fitting constructor could not be found because", constructorArgs);
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(constructorArgTypes);
            return ReflectionTestUtils.newInstance(constructor, constructorArgs);
        }
        catch (NoSuchMethodException nsme) {
            throw ReflectionTestUtils.failure(failMessage + " the class does not have a constructor with the arguments: " + ReflectionTestUtils.getParameterTypesAsString(constructorArgTypes) + ". Make sure to implement this constructor properly.");
        }
    }

    public static Object newInstance(Constructor<?> constructor, Object ... constructorArgs) {
        String failMessage = "Could not instantiate the class " + constructor.getDeclaringClass().getSimpleName() + BECAUSE;
        try {
            return constructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException iae) {
            throw ReflectionTestUtils.failure(failMessage + " access to its constructor with the parameters: " + ReflectionTestUtils.getParameterTypesAsString(constructor.getParameterTypes()) + " was denied. Make sure to check the modifiers of the constructor.");
        }
        catch (IllegalArgumentException iae) {
            throw ReflectionTestUtils.failure(failMessage + " the actual constructor or none of the actual constructors of this class match the expected one. We expect, amongst others, one with " + ReflectionTestUtils.getParameterTypesAsString(constructor.getParameterTypes()) + " parameters, which does not exist. Make sure to implement this constructor correctly.");
        }
        catch (InstantiationException ie) {
            throw ReflectionTestUtils.failure(failMessage + " the class is abstract and should not have a constructor. Make sure to remove the constructor of the class.");
        }
        catch (InvocationTargetException ite) {
            throw ReflectionTestUtils.failure(failMessage + THE_CONSTRUCTOR_WITH + constructorArgs.length + " parameters threw an exception and could not be initialized. Make sure to check the constructor implementation.");
        }
        catch (ExceptionInInitializerError eiie) {
            throw ReflectionTestUtils.failure(failMessage + THE_CONSTRUCTOR_WITH + constructorArgs.length + " parameters could not be initialized.");
        }
    }

    public static Object valueForAttribute(Object object, String attributeName) {
        Objects.requireNonNull(object, "Could not retrieve the value of attribute '" + attributeName + "' because the object was null.");
        String failMessage = "Could not retrieve the attribute '" + attributeName + "' from the class " + object.getClass().getSimpleName() + BECAUSE;
        try {
            return object.getClass().getDeclaredField(attributeName).get(object);
        }
        catch (NoSuchFieldException nsfe) {
            throw ReflectionTestUtils.failure(failMessage + " the attribute does not exist. Make sure to implement the attribute correctly.");
        }
        catch (IllegalAccessException iae) {
            throw ReflectionTestUtils.failure(failMessage + " access to the attribute was denied. Make sure to check the modifiers of the attribute.");
        }
    }

    public static Method getMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(object, "Could not find the method '" + methodName + "' because the object was null.");
        return ReflectionTestUtils.getMethod(object.getClass(), methodName, parameterTypes);
    }

    public static Method getMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        String failMessage = "Could not find the method '" + methodName + "' with the parameters: " + ReflectionTestUtils.getParameterTypesAsString(parameterTypes) + " in the class " + declaringClass.getSimpleName() + BECAUSE;
        if (parameterTypes == null || parameterTypes.length == 0) {
            failMessage = "Could not find the method '" + methodName + "' from the class " + declaringClass.getSimpleName() + BECAUSE;
        }
        try {
            return declaringClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw ReflectionTestUtils.failure(failMessage + " the method does not exist. Make sure to implement this method properly.");
        }
        catch (NullPointerException npe) {
            throw ReflectionTestUtils.failure(failMessage + " the name of the method is null. Make sure to check the name of the method.");
        }
    }

    public static Object invokeMethod(Object object, String methodName, Object ... params) {
        String failMessage = "Could not find the method '" + methodName + "' because";
        Class<?>[] parameterTypes = ReflectionTestUtils.getParameterTypes(failMessage, params);
        Method method = ReflectionTestUtils.getMethod(object, methodName, parameterTypes);
        return ReflectionTestUtils.invokeMethod(object, method, params);
    }

    public static Object invokeMethod(Object object, Method method, Object ... params) {
        String failMessage = "Could not invoke the method '" + method.getName() + "' in the class " + method.getDeclaringClass().getSimpleName() + BECAUSE;
        try {
            return ReflectionTestUtils.invokeMethodRethrowing(object, method, params);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable e) {
            throw ReflectionTestUtils.failure(failMessage + " of an exception within the method: " + e);
        }
    }

    public static Object invokeMethodRethrowing(Object object, Method method, Object ... params) throws Throwable {
        String failMessage = "Could not invoke the method '" + method.getName() + "' in the class " + method.getDeclaringClass().getSimpleName() + BECAUSE;
        try {
            return method.invoke(object, params);
        }
        catch (IllegalAccessException iae) {
            throw ReflectionTestUtils.failure(failMessage + " access to the method was denied. Make sure to check the modifiers of the method.");
        }
        catch (IllegalArgumentException iae) {
            throw ReflectionTestUtils.failure(failMessage + " the parameters are not implemented right. Make sure to check the parameters of the method.");
        }
        catch (NullPointerException e) {
            throw ReflectionTestUtils.failure(failMessage + " the object was null and the method is an instance method. Make sure to check the static modifier of the method.");
        }
        catch (ExceptionInInitializerError e) {
            throw ReflectionTestUtils.failure(failMessage + " the static initialization provoked by this method failed. Make sure to check the initialization triggered by this method.");
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> declaringClass, Class<?> ... parameterTypes) {
        String failMessage = "Could not find the constructor with the parameters: " + ReflectionTestUtils.getParameterTypesAsString(parameterTypes) + " in the class " + declaringClass.getSimpleName() + BECAUSE;
        if (parameterTypes == null || parameterTypes.length == 0) {
            failMessage = "Could not find the constructor from the " + declaringClass.getSimpleName() + BECAUSE;
        }
        try {
            return declaringClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw ReflectionTestUtils.failure(failMessage + " the constructor does not exist. Make sure to implement this constructor properly.");
        }
    }

    private static Class<?>[] getParameterTypes(String failMessage, Object ... params) {
        return (Class[])Arrays.stream(params).map(it -> Objects.requireNonNull(it, failMessage + " one of the supplied arguments was null.")).map(Object::getClass).toArray(Class[]::new);
    }

    private static String getParameterTypesAsString(Class<?> ... parameterTypes) {
        StringJoiner joiner = new StringJoiner(", ", "[ ", " ]");
        joiner.setEmptyValue("none");
        Arrays.stream(parameterTypes).map(type -> Objects.requireNonNull(type, "One of the supplied types was null.")).map(Class::getSimpleName).forEach(joiner::add);
        return joiner.toString();
    }

    private static AssertionError failure(String failureMessage) {
        return new AssertionFailedError(failureMessage);
    }
}

