/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jqwik;

import de.tum.in.test.api.internal.ConfigurationUtils;
import de.tum.in.test.api.jqwik.JqwikContext;
import de.tum.in.test.api.security.ArtemisSecurityConfiguration;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import java.util.Optional;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class JqwikSecurityExtension
implements AroundPropertyHook {
    public int aroundPropertyProximity() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) throws Throwable {
        PropertyExecutionResult result;
        JqwikContext testContext = JqwikContext.of(context);
        ArtemisSecurityConfiguration configuration = ConfigurationUtils.generateConfiguration(testContext);
        String accessToken = ArtemisSecurityManager.install(configuration);
        Exception error = null;
        try {
            result = property.execute();
        }
        finally {
            try {
                ArtemisSecurityManager.uninstall(accessToken);
            }
            catch (Exception e) {
                error = e;
            }
        }
        if (error != null) {
            Optional propExecError = result.throwable();
            if (propExecError.isPresent()) {
                ((Throwable)propExecError.get()).addSuppressed(error);
            } else {
                result = result.mapToFailed((Throwable)error);
            }
        }
        return result;
    }
}

