/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class IgnorantUnmodifiableList<E>
extends AbstractList<E>
implements RandomAccess {
    private final List<E> list;
    private final BiConsumer<String, Object> onModification;

    public IgnorantUnmodifiableList(List<E> original) {
        this(original, (method, object) -> {});
    }

    public IgnorantUnmodifiableList(List<E> original, BiConsumer<String, Object> onModification) {
        this.list = Objects.requireNonNull(original);
        this.onModification = Objects.requireNonNull(onModification);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> it = this.list.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                return it.next();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.onModification.accept("add(E)", e);
        return false;
    }

    @Override
    public boolean remove(Object o) {
        this.onModification.accept("remove(Object)", o);
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.onModification.accept("addAll(Collection<? extends E>)", c);
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.onModification.accept("addAll(int, Collection<? extends E>)", c);
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.onModification.accept("removeAll(Collection<?>)", c);
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.onModification.accept("retainAll(Collection<?>)", c);
        return false;
    }

    @Override
    public void clear() {
        this.onModification.accept("clear()", null);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        this.onModification.accept("set(int, E)", element);
        return null;
    }

    @Override
    public void add(int index, E element) {
        this.onModification.accept("add(int, E)", element);
    }

    @Override
    public E remove(int index) {
        this.onModification.accept("remove(int)", index);
        return null;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        final ListIterator<E> it = this.list.listIterator(index);
        return new ListIterator<E>(){
            private boolean changeAllowed;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public E next() {
                this.changeAllowed = true;
                return it.next();
            }

            @Override
            public boolean hasPrevious() {
                return it.hasPrevious();
            }

            @Override
            public E previous() {
                this.changeAllowed = true;
                return it.previous();
            }

            @Override
            public int nextIndex() {
                return it.nextIndex();
            }

            @Override
            public int previousIndex() {
                return it.previousIndex();
            }

            @Override
            public void remove() {
                this.checkChangeAction();
                this.changeAllowed = false;
                IgnorantUnmodifiableList.this.remove(it.nextIndex() - 1);
            }

            @Override
            public void set(E e) {
                this.checkChangeAction();
                IgnorantUnmodifiableList.this.set(0, e);
            }

            @Override
            public void add(E e) {
                this.changeAllowed = false;
                IgnorantUnmodifiableList.this.add(e);
            }

            private void checkChangeAction() {
                if (!this.changeAllowed) {
                    throw new IllegalStateException();
                }
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    public static <E> List<E> wrap(List<E> original) {
        return new IgnorantUnmodifiableList<E>(original);
    }

    public static <E> List<E> wrapWith(List<E> original, BiConsumer<String, Object> onModification) {
        return new IgnorantUnmodifiableList<E>(original, onModification);
    }
}

