/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.structural.testutils;

import de.tum.in.test.api.structural.testutils.ScanResult;
import de.tum.in.test.api.structural.testutils.ScanResultType;
import info.debatty.java.stringsimilarity.Damerau;
import info.debatty.java.stringsimilarity.JaroWinkler;
import info.debatty.java.stringsimilarity.NormalizedLevenshtein;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClassNameScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClassNameScanner.class);
    private static final JaroWinkler JARO_WINKLER = new JaroWinkler();
    private static final NormalizedLevenshtein NORMALIZED_LEVENSHTEIN = new NormalizedLevenshtein();
    private static final Damerau DAMERAU_LEVENSHTEIN = new Damerau();
    private static final String DEVIATES_FROM_THE_EXPECTATION = ", which deviates from the expectation.";
    private static final String IMPLEMENTED_A_CLASS = "We found that you implemented a class ";
    private static final String THE_CLASS = "The class ";
    private static final String EXPECTS_CLASS_WITH_NAME = "The exercise expects a class with the name ";
    private static final String IN_THE_PACKAGE = " in the package ";
    private static final String CORRECT_NAME = " has the correct name";
    private final String expectedClassName;
    private final String expectedPackageName;
    private final Map<String, List<String>> observedClasses = new HashMap<String, List<String>>();
    private final ScanResult scanResult;
    private static String pomXmlPath = "pom.xml";

    public ClassNameScanner(String expectedClassName, String expectedPackageName) {
        this.expectedClassName = expectedClassName;
        this.expectedPackageName = expectedPackageName;
        this.findObservedClassesInProject();
        this.scanResult = this.computeScanResult();
    }

    public ScanResult getScanResult() {
        return this.scanResult;
    }

    private ScanResult computeScanResult() {
        if (this.observedClasses.containsKey(this.expectedClassName)) {
            List<String> observedPackageNames = this.observedClasses.get(this.expectedClassName);
            return this.createScanResult(this.getScanResultTypeClassFound(observedPackageNames), this.expectedClassName, observedPackageNames.toString());
        }
        for (Map.Entry<String, List<String>> observedClass : this.observedClasses.entrySet()) {
            boolean classCorrectlyPlaced;
            String foundObservedClassName = observedClass.getKey();
            List<String> observedPackageNames = observedClass.getValue();
            String foundObservedPackageNames = observedPackageNames.toString();
            boolean classPresentMultiple = observedPackageNames.size() > 1;
            boolean bl = classCorrectlyPlaced = !classPresentMultiple && observedPackageNames.contains(this.expectedPackageName);
            if (foundObservedClassName.equalsIgnoreCase(this.expectedClassName)) {
                return this.createScanResult(foundObservedClassName, foundObservedPackageNames, classPresentMultiple, classCorrectlyPlaced, ScanResultType.WRONG_CASE_MULTIPLE, ScanResultType.WRONG_CASE_CORRECT_PLACE, ScanResultType.WRONG_CASE_MISPLACED);
            }
            if (!ClassNameScanner.isMisspelledWithHighProbability(this.expectedClassName, foundObservedClassName)) continue;
            return this.createScanResult(foundObservedClassName, foundObservedPackageNames, classPresentMultiple, classCorrectlyPlaced, ScanResultType.TYPOS_MULTIPLE, ScanResultType.TYPOS_CORRECT_PLACE, ScanResultType.TYPOS_MISPLACED);
        }
        return this.createScanResult(ScanResultType.NOTFOUND, this.expectedClassName, null);
    }

    private ScanResult createScanResult(String foundObservedClassName, String foundObservedPackageName, boolean classPresentMultiple, boolean classCorrectlyPlaced, ScanResultType multipleTimes, ScanResultType correctPlace, ScanResultType misplaced) {
        ScanResultType scanResultType = classPresentMultiple ? multipleTimes : (classCorrectlyPlaced ? correctPlace : misplaced);
        return this.createScanResult(scanResultType, foundObservedClassName, foundObservedPackageName);
    }

    private ScanResultType getScanResultTypeClassFound(List<String> observedPackageNames) {
        boolean classIsCorrectlyPlaced;
        boolean classIsPresentMultipleTimes = observedPackageNames.size() > 1;
        boolean bl = classIsCorrectlyPlaced = !classIsPresentMultipleTimes && observedPackageNames.contains(this.expectedPackageName);
        ScanResultType scanResultType = classIsPresentMultipleTimes ? ScanResultType.CORRECT_NAME_MULTIPLE : (classIsCorrectlyPlaced ? ScanResultType.CORRECT_NAME_CORRECT_PLACE : ScanResultType.CORRECT_NAME_MISPLACED);
        return scanResultType;
    }

    private ScanResult createScanResult(ScanResultType scanResultType, String foundObservedClassName, String foundObservedPackageName) {
        Object scanResultMessage;
        switch (scanResultType) {
            case CORRECT_NAME_CORRECT_PLACE: {
                scanResultMessage = THE_CLASS + foundObservedClassName + " has the correct name and is in the correct package.";
                break;
            }
            case CORRECT_NAME_MISPLACED: {
                scanResultMessage = THE_CLASS + foundObservedClassName + " has the correct name, but the package it's in, " + foundObservedPackageName + ", deviates from the expectation.  Make sure it is placed in the correct package.";
                break;
            }
            case CORRECT_NAME_MULTIPLE: {
                scanResultMessage = THE_CLASS + foundObservedClassName + " has the correct name, but it is located multiple times in the project and in the packages: " + foundObservedPackageName + ", which deviates from the expectation. Make sure to place the class in the correct package and remove any superfluous ones.";
                break;
            }
            case WRONG_CASE_CORRECT_PLACE: {
                scanResultMessage = EXPECTS_CLASS_WITH_NAME + this.expectedClassName + ". We found that you implemented a class " + foundObservedClassName + ", which deviates from the expectation. Check for wrong upper case / lower case lettering.";
                break;
            }
            case WRONG_CASE_MISPLACED: {
                scanResultMessage = EXPECTS_CLASS_WITH_NAME + this.expectedClassName + IN_THE_PACKAGE + this.expectedPackageName + ". We found that you implemented a class " + foundObservedClassName + ", in the package " + foundObservedPackageName + ", which deviates from the expectation. Check for wrong upper case / lower case lettering and make sure you place it in the correct package.";
                break;
            }
            case WRONG_CASE_MULTIPLE: {
                scanResultMessage = EXPECTS_CLASS_WITH_NAME + this.expectedClassName + IN_THE_PACKAGE + this.expectedPackageName + ". We found that you implemented a class " + foundObservedClassName + ", in the package " + foundObservedPackageName + ", which deviates from the expectation. Check for wrong upper case / lower case lettering and make sure you place one class in the correct package and remove any superfluous classes.";
                break;
            }
            case TYPOS_CORRECT_PLACE: {
                scanResultMessage = EXPECTS_CLASS_WITH_NAME + this.expectedClassName + ". We found that you implemented a class " + foundObservedClassName + ", which deviates from the expectation. Check for typos in the class name.";
                break;
            }
            case TYPOS_MISPLACED: {
                scanResultMessage = EXPECTS_CLASS_WITH_NAME + this.expectedClassName + IN_THE_PACKAGE + this.expectedPackageName + ". We found that you implemented a class " + foundObservedClassName + ", in the package " + foundObservedPackageName + ", which deviates from the expectation. Check for typos in the class name and make sure you place it in the correct package.";
                break;
            }
            case TYPOS_MULTIPLE: {
                scanResultMessage = EXPECTS_CLASS_WITH_NAME + this.expectedClassName + IN_THE_PACKAGE + this.expectedPackageName + ". We found that you implemented a class " + foundObservedClassName + ", in the package " + this.observedClasses.get(foundObservedClassName).toString() + ", which deviates from the expectation. Check for typos in the class name and make sure you place one class it in the correct package and remove any superfluous classes.";
                break;
            }
            case NOTFOUND: {
                scanResultMessage = EXPECTS_CLASS_WITH_NAME + this.expectedClassName + IN_THE_PACKAGE + this.expectedPackageName + ". You did not implement the class in the exercise.";
                break;
            }
            default: {
                scanResultMessage = "The class could not be scanned.";
            }
        }
        return new ScanResult(scanResultType, (String)scanResultMessage);
    }

    private void findObservedClassesInProject() {
        try {
            File pomFile = new File(pomXmlPath);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document pomXmlDocument = documentBuilder.parse(pomFile);
            NodeList buildNodes = pomXmlDocument.getElementsByTagName("build");
            for (int i = 0; i < buildNodes.getLength(); ++i) {
                Node buildNode = buildNodes.item(i);
                if (buildNode.getNodeType() != 1) continue;
                Element buildNodeElement = (Element)buildNode;
                String sourceDirectoryPropertyValue = buildNodeElement.getElementsByTagName("sourceDirectory").item(0).getTextContent();
                String assignmentFolderName = sourceDirectoryPropertyValue.substring(sourceDirectoryPropertyValue.indexOf("}") + 2);
                this.walkProjectFileStructure(assignmentFolderName, new File(assignmentFolderName), this.observedClasses);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("Could not retrieve the source directory from the pom.xml file. Contact your instructor.", (Throwable)e);
        }
    }

    private void walkProjectFileStructure(String assignmentFolderName, File node, Map<String, List<String>> foundClasses) {
        String[] subNodes;
        String fileName = node.getName();
        if (fileName.endsWith(".java") || fileName.endsWith(".kt")) {
            String[] fileNameComponents = fileName.split("\\.");
            String className = fileNameComponents[fileNameComponents.length - 2];
            Path packagePath = Path.of(assignmentFolderName, new String[0]).relativize(Path.of(node.getPath(), new String[0]).getParent());
            String packageName = StreamSupport.stream(packagePath.spliterator(), false).map(Object::toString).collect(Collectors.joining("."));
            if (foundClasses.containsKey(className)) {
                foundClasses.get(className).add(packageName);
            } else {
                foundClasses.put(className, new ArrayList<String>(List.of(packageName)));
            }
        }
        if (node.isDirectory() && (subNodes = node.list()) != null && subNodes.length > 0) {
            for (String currentSubNode : subNodes) {
                this.walkProjectFileStructure(assignmentFolderName, new File(node, currentSubNode), foundClasses);
            }
        }
    }

    public static String getPomXmlPath() {
        return pomXmlPath;
    }

    public static void setPomXmlPath(String path) {
        pomXmlPath = path;
    }

    static boolean isMisspelledWithHighProbability(String a, String b) {
        int lengthDifferenceAbs = Math.abs(a.length() - b.length());
        if (lengthDifferenceAbs > 2) {
            return false;
        }
        double distance = DAMERAU_LEVENSHTEIN.distance(a, b);
        if (distance <= 1.0 && Math.max(a.length(), b.length()) > 2) {
            return true;
        }
        if (distance > 2.0) {
            return false;
        }
        return JARO_WINKLER.similarity(a, b) > 0.9 || NORMALIZED_LEVENSHTEIN.similarity(a, b) > 0.9;
    }
}

