/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.structural;

import de.tum.in.test.api.structural.testutils.ClassNameScanner;
import de.tum.in.test.api.structural.testutils.ScanResultType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StructuralTestProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StructuralTestProvider.class);
    protected static final String JSON_PROPERTY_SUPERCLASS = "superclass";
    protected static final String JSON_PROPERTY_INTERFACES = "interfaces";
    protected static final String JSON_PROPERTY_ANNOTATIONS = "annotations";
    protected static final String JSON_PROPERTY_MODIFIERS = "modifiers";
    protected static final String JSON_PROPERTY_PARAMETERS = "parameters";
    protected static final String JSON_PROPERTY_CONSTRUCTORS = "constructors";
    protected static final String JSON_PROPERTY_CLASS = "class";
    protected static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    protected static final String JSON_PROPERTY_METHODS = "methods";
    protected static final String JSON_PROPERTY_PACKAGE = "package";
    protected static final String JSON_PROPERTY_NAME = "name";
    protected static final String JSON_PROPERTY_TYPE = "type";
    protected static final String JSON_PROPERTY_RETURN_TYPE = "returnType";
    protected static final String JSON_PROPERTY_ENUM_VALUES = "enumValues";
    protected static final String JSON_PROPERTY_STRICT_ORDER = "strictOrder";
    protected static final String THE_CLASS = "The class ";
    protected static final String THE_TYPE = "The type ";
    protected static final String THE_ENUM = "The enum ";
    protected static final String NOT_IMPLEMENTED_AS_EXPECTED = " are not implemented as expected.";
    private static final Pattern PACKAGE_NAME_IN_GENERIC_TYPE = Pattern.compile("(?:[^\\[\\]<>?,\\s.]++\\.)++");
    protected static JSONArray structureOracleJSON;

    protected StructuralTestProvider() {
    }

    protected static Class<?> findClassForTestType(ExpectedClassStructure expectedClassStructure, String typeOfTest) {
        ClassNameScanner classNameScanner = new ClassNameScanner(expectedClassStructure.getExpectedClassName(), expectedClassStructure.getExpectedPackageName());
        ScanResultType scanResultEnum = classNameScanner.getScanResult().getResult();
        String classNameScanMessage = classNameScanner.getScanResult().getMessage();
        if (!ScanResultType.CORRECT_NAME_CORRECT_PLACE.equals((Object)scanResultEnum)) {
            Assertions.fail((String)classNameScanMessage);
        }
        try {
            return Class.forName(expectedClassStructure.getQualifiedClassName(), false, StructuralTestProvider.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            Assertions.fail((String)("Problem during " + typeOfTest + " test: " + classNameScanMessage + ". Double check that you have implemented the class correctly!"));
            return null;
        }
    }

    protected static JSONArray getExpectedJsonProperty(JSONObject element, String jsonPropertyKey) {
        return element.has(jsonPropertyKey) ? element.getJSONArray(jsonPropertyKey) : new JSONArray();
    }

    protected static boolean getExpectedJsonBooleanProperty(JSONObject element, String jsonPropertyKey) {
        return element.has(jsonPropertyKey) ? element.getBoolean(jsonPropertyKey) : false;
    }

    protected static boolean checkModifiers(String[] observedModifiers, JSONArray expectedModifiers) {
        if (Arrays.equals(observedModifiers, new String[]{""}) && expectedModifiers.length() == 0) {
            return true;
        }
        HashSet<ModifierSpecification> modifierSpecifications = new HashSet<ModifierSpecification>();
        for (int i = 0; i < expectedModifiers.length(); ++i) {
            modifierSpecifications.add(ModifierSpecification.getModifierForJsonString(expectedModifiers.getString(i)));
        }
        Set<String> observedModifiersSet = Set.of(observedModifiers);
        Set allowedModifiers = modifierSpecifications.stream().map(ModifierSpecification::getModifier).collect(Collectors.toSet());
        boolean hasAllNecessaryModifiers = modifierSpecifications.stream().filter(ModifierSpecification::isRequired).map(ModifierSpecification::getModifier).allMatch(observedModifiersSet::contains);
        boolean hasForbiddenModifier = observedModifiersSet.stream().anyMatch(modifier -> !allowedModifiers.contains(modifier));
        return hasAllNecessaryModifiers && !hasForbiddenModifier;
    }

    protected static boolean checkAnnotations(Annotation[] observedAnnotations, JSONArray expectedAnnotations) {
        if (observedAnnotations.length == 0 && expectedAnnotations.length() == 0) {
            return true;
        }
        if (observedAnnotations.length != expectedAnnotations.length()) {
            return false;
        }
        for (Object expectedAnnotation : expectedAnnotations) {
            boolean expectedAnnotationFound = false;
            String expectedAnnotationAsString = (String)expectedAnnotation;
            for (Annotation observedAnnotation : observedAnnotations) {
                if (!StructuralTestProvider.checkExpectedType(observedAnnotation.annotationType(), observedAnnotation.annotationType(), expectedAnnotationAsString)) continue;
                expectedAnnotationFound = true;
                break;
            }
            if (expectedAnnotationFound) continue;
            return false;
        }
        return true;
    }

    protected static boolean checkParameters(Class<?>[] observedParameters, JSONArray expectedParameters, boolean strictOrder) {
        if (observedParameters.length == 0 && expectedParameters.length() == 0) {
            return true;
        }
        if (observedParameters.length != expectedParameters.length()) {
            return false;
        }
        Object[] expectedParameterTypeNames = new String[expectedParameters.length()];
        for (int i = 0; i < expectedParameters.length(); ++i) {
            expectedParameterTypeNames[i] = expectedParameters.getString(i);
        }
        Object[] observedParameterTypeNames = new String[observedParameters.length];
        for (int i = 0; i < observedParameters.length; ++i) {
            observedParameterTypeNames[i] = observedParameters[i].getSimpleName();
        }
        if (strictOrder) {
            return Arrays.equals(expectedParameterTypeNames, observedParameterTypeNames);
        }
        Map<String, Integer> expectedParametersHashtable = StructuralTestProvider.createParametersHashMap((String[])expectedParameterTypeNames);
        Map<String, Integer> observedParametersHashtable = StructuralTestProvider.createParametersHashMap((String[])observedParameterTypeNames);
        return expectedParametersHashtable.equals(observedParametersHashtable);
    }

    protected static boolean checkExpectedType(Class<?> actualClass, Type actualGenericType, String expectedTypeName) {
        String actualName;
        boolean expectedTypeIsGeneric;
        boolean bl = expectedTypeIsGeneric = expectedTypeName.contains("<") && expectedTypeName.contains(">");
        if (expectedTypeIsGeneric) {
            actualName = actualGenericType.getTypeName();
        } else {
            actualName = actualClass.getCanonicalName();
            if (actualName == null) {
                actualName = actualClass.getName();
            }
        }
        String actualSimpleName = PACKAGE_NAME_IN_GENERIC_TYPE.matcher(actualName).replaceAll("");
        if (expectedTypeName.contains(".")) {
            return expectedTypeName.equals(actualName);
        }
        return expectedTypeName.equals(actualSimpleName);
    }

    protected static Map<String, Integer> createParametersHashMap(String ... parameterTypeNames) {
        HashMap<String, Integer> parametersHashTable = new HashMap<String, Integer>();
        for (String parameterTypeName : parameterTypeNames) {
            if (!parametersHashTable.containsKey(parameterTypeName)) {
                parametersHashTable.put(parameterTypeName, 1);
                continue;
            }
            Integer currentParameterCount = (Integer)parametersHashTable.get(parameterTypeName);
            parametersHashTable.replace(parameterTypeName, currentParameterCount, currentParameterCount + 1);
        }
        return parametersHashTable;
    }

    protected static JSONArray retrieveStructureOracleJSON(URL structureOracleFileUrl) {
        if (structureOracleFileUrl == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(structureOracleFileUrl.openStream()));){
            int length;
            char[] buffer = new char[8192];
            while ((length = bufferedReader.read(buffer, 0, buffer.length)) != -1) {
                result.append(buffer, 0, length);
            }
        }
        catch (IOException e) {
            LOG.error("Could not open stream from URL: {}", (Object)structureOracleFileUrl, (Object)e);
        }
        return new JSONArray(result.toString());
    }

    protected static class ExpectedClassStructure {
        private final String expectedClassName;
        private final String expectedPackageName;
        private final JSONObject expectedClassJson;

        public ExpectedClassStructure(String expectedClassName, String expectedPackageName, JSONObject expectedClassJson) {
            this.expectedClassName = Objects.requireNonNull(expectedClassName);
            this.expectedPackageName = Objects.requireNonNull(expectedPackageName);
            this.expectedClassJson = Objects.requireNonNull(expectedClassJson);
        }

        public String getExpectedClassName() {
            return this.expectedClassName;
        }

        public String getExpectedPackageName() {
            return this.expectedPackageName;
        }

        public JSONObject getExpectedClassJson() {
            return this.expectedClassJson;
        }

        public String getQualifiedClassName() {
            if (!this.expectedPackageName.isEmpty()) {
                return this.expectedPackageName + "." + this.expectedClassName;
            }
            return this.expectedClassName;
        }

        public boolean hasProperty(String propertyName) {
            return this.getExpectedClassJson().has(propertyName);
        }

        public JSONObject getPropertyAsJsonObject(String propertyName) {
            return this.getExpectedClassJson().getJSONObject(propertyName);
        }

        public JSONArray getPropertyAsJsonArray(String propertyName) {
            return this.getExpectedClassJson().getJSONArray(propertyName);
        }
    }

    private static final class ModifierSpecification {
        private final String modifier;
        private final boolean optional;

        private ModifierSpecification(String modifier, boolean optional) {
            this.modifier = Objects.requireNonNull(modifier);
            this.optional = optional;
        }

        String getModifier() {
            return this.modifier;
        }

        boolean isRequired() {
            return !this.optional;
        }

        static ModifierSpecification getModifierForJsonString(String jsonString) {
            String[] sections = jsonString.split(":", -1);
            if (sections.length == 1) {
                return new ModifierSpecification(jsonString, false);
            }
            if ("optional".equals(sections[0])) {
                return new ModifierSpecification(sections[1].trim(), true);
            }
            throw new IllegalArgumentException("Invalid entry for modifier: '" + jsonString + "'");
        }
    }
}

