/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.structural;

import de.tum.in.test.api.structural.StructuralTestProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;

public abstract class ClassTestProvider
extends StructuralTestProvider {
    protected DynamicContainer generateTestsForAllClasses() throws URISyntaxException {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        if (structureOracleJSON == null) {
            Assertions.fail((String)"The ClassTest test can only run if the structural oracle (test.json) is present. If you do not provide it, delete ClassTest.java!");
        }
        for (int i = 0; i < structureOracleJSON.length(); ++i) {
            JSONObject expectedClassJSON = structureOracleJSON.getJSONObject(i);
            JSONObject expectedClassPropertiesJSON = expectedClassJSON.getJSONObject("class");
            if (!expectedClassPropertiesJSON.has("name") || !expectedClassPropertiesJSON.has("package") || !ClassTestProvider.hasAdditionalProperties(expectedClassPropertiesJSON)) continue;
            String expectedClassName = expectedClassPropertiesJSON.getString("name");
            String expectedPackageName = expectedClassPropertiesJSON.getString("package");
            StructuralTestProvider.ExpectedClassStructure expectedClassStructure = new StructuralTestProvider.ExpectedClassStructure(expectedClassName, expectedPackageName, expectedClassJSON);
            tests.add(DynamicTest.dynamicTest((String)("testClass[" + expectedClassName + "]"), () -> ClassTestProvider.testClass(expectedClassStructure)));
        }
        if (tests.isEmpty()) {
            Assertions.fail((String)"No tests for classes available in the structural oracle (test.json). Either provide attributes information or delete ClassTest.java!");
        }
        return DynamicContainer.dynamicContainer((String)this.getClass().getName(), (URI)new URI(this.getClass().getName()), tests.stream());
    }

    protected static boolean hasAdditionalProperties(JSONObject jsonObject) {
        ArrayList keys = new ArrayList(jsonObject.keySet());
        keys.remove("name");
        keys.remove("package");
        return !keys.isEmpty();
    }

    protected static void testClass(StructuralTestProvider.ExpectedClassStructure expectedClassStructure) {
        String expectedClassName = expectedClassStructure.getExpectedClassName();
        Class<?> observedClass = ClassTestProvider.findClassForTestType(expectedClassStructure, "class");
        if (observedClass == null) {
            Assertions.fail((String)("The class " + expectedClassName + " was not found for class test"));
            return;
        }
        JSONObject expectedClassPropertiesJSON = expectedClassStructure.getPropertyAsJsonObject("class");
        ClassTestProvider.checkBasicClassProperties(expectedClassName, observedClass, expectedClassPropertiesJSON);
        ClassTestProvider.checkSuperclass(expectedClassName, observedClass, expectedClassPropertiesJSON);
        ClassTestProvider.checkInterfaces(expectedClassName, observedClass, expectedClassPropertiesJSON);
        ClassTestProvider.checkAnnotations(expectedClassName, observedClass, expectedClassPropertiesJSON);
    }

    private static void checkBasicClassProperties(String expectedClassName, Class<?> observedClass, JSONObject expectedClassPropertiesJSON) {
        if (ClassTestProvider.checkBooleanOf(expectedClassPropertiesJSON, "isAbstract") && !Modifier.isAbstract(observedClass.getModifiers())) {
            Assertions.fail((String)("The class '" + expectedClassName + "' is not abstract as it is expected."));
        }
        if (ClassTestProvider.checkBooleanOf(expectedClassPropertiesJSON, "isEnum") && !observedClass.isEnum()) {
            Assertions.fail((String)("The type '" + expectedClassName + "' is not an enum as it is expected."));
        }
        if (ClassTestProvider.checkBooleanOf(expectedClassPropertiesJSON, "isInterface") && !Modifier.isInterface(observedClass.getModifiers())) {
            Assertions.fail((String)("The type '" + expectedClassName + "' is not an interface as it is expected."));
        }
        if (expectedClassPropertiesJSON.has("modifiers")) {
            JSONArray expectedModifiers = ClassTestProvider.getExpectedJsonProperty(expectedClassPropertiesJSON, "modifiers");
            boolean modifiersAreCorrect = ClassTestProvider.checkModifiers(Modifier.toString(observedClass.getModifiers()).split(" "), expectedModifiers);
            if (!modifiersAreCorrect) {
                Assertions.fail((String)("The modifier(s) (access type, abstract, etc.) of " + expectedClassName + " are not implemented as expected."));
            }
        }
    }

    private static boolean checkBooleanOf(JSONObject expectedClassPropertiesJSON, String booleanProperty) {
        return expectedClassPropertiesJSON.has(booleanProperty) && expectedClassPropertiesJSON.getBoolean(booleanProperty);
    }

    private static void checkSuperclass(String expectedClassName, Class<?> observedClass, JSONObject expectedClassPropertiesJSON) {
        if (expectedClassPropertiesJSON.has("superclass") && !"Enum".equals(expectedClassPropertiesJSON.getString("superclass"))) {
            String expectedSuperClassName = expectedClassPropertiesJSON.getString("superclass");
            if (!ClassTestProvider.checkExpectedType(observedClass.getSuperclass(), observedClass.getGenericSuperclass(), expectedSuperClassName)) {
                String failMessage = "The class '" + expectedClassName + "' is not a subclass of the class '" + expectedSuperClassName + "' as expected. Implement the class inheritance properly.";
                Assertions.fail((String)failMessage);
            }
        }
    }

    private static void checkInterfaces(String expectedClassName, Class<?> observedClass, JSONObject expectedClassPropertiesJSON) {
        if (expectedClassPropertiesJSON.has("interfaces")) {
            JSONArray expectedInterfaces = expectedClassPropertiesJSON.getJSONArray("interfaces");
            Class<?>[] observedInterfaces = observedClass.getInterfaces();
            Type[] observedGenericInterfaceTypes = observedClass.getGenericInterfaces();
            for (int i = 0; i < expectedInterfaces.length(); ++i) {
                String expectedInterface = expectedInterfaces.getString(i);
                boolean implementsInterface = false;
                for (int j = 0; j < observedInterfaces.length; ++j) {
                    Class<?> observedInterface = observedInterfaces[j];
                    Type observedGenericInterfaceType = observedGenericInterfaceTypes[j];
                    if (!ClassTestProvider.checkExpectedType(observedInterface, observedGenericInterfaceType, expectedInterface)) continue;
                    implementsInterface = true;
                    break;
                }
                if (implementsInterface) continue;
                Assertions.fail((String)("The class '" + expectedClassName + "' does not implement the interface '" + expectedInterface + "' as expected. Implement the interface and its methods."));
            }
        }
    }

    private static void checkAnnotations(String expectedClassName, Class<?> observedClass, JSONObject expectedClassPropertiesJSON) {
        if (expectedClassPropertiesJSON.has("annotations")) {
            JSONArray expectedAnnotations = expectedClassPropertiesJSON.getJSONArray("annotations");
            Annotation[] observedAnnotations = observedClass.getAnnotations();
            boolean annotationsAreRight = ClassTestProvider.checkAnnotations(observedAnnotations, expectedAnnotations);
            if (!annotationsAreRight) {
                Assertions.fail((String)("The annotation(s) of the class '" + expectedClassName + "' are not implemented as expected."));
            }
        }
    }
}

