/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.dynamic;

import de.tum.in.test.api.dynamic.Check;
import de.tum.in.test.api.dynamic.Checkable;
import de.tum.in.test.api.dynamic.DynamicClass;
import de.tum.in.test.api.dynamic.DynamicMethod;
import de.tum.in.test.api.util.UnexpectedExceptionError;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.jupiter.api.Assertions;

@API(status=API.Status.EXPERIMENTAL)
public class DynamicConstructor<T>
implements Checkable {
    private final DynamicClass<T> owner;
    private final DynamicClass<?>[] parameters;
    private Constructor<T> constructor;

    public DynamicConstructor(DynamicClass<T> dClass, Object ... dynamicableParams) {
        this.owner = Objects.requireNonNull(dClass);
        this.parameters = DynamicClass.toDynamic(Objects.requireNonNull(dynamicableParams));
    }

    public Constructor<T> toConstructor() {
        if (this.constructor == null) {
            try {
                this.constructor = this.owner.toClass().getDeclaredConstructor(DynamicClass.resolveAll(this.parameters));
                this.constructor.trySetAccessible();
            }
            catch (NoSuchMethodException e) {
                Assertions.fail((String)("Kein Konstruktor f\u00fcr " + this.owner + " mit Parametern " + DynamicMethod.descParams(this.parameters) + " gefunden."), (Throwable)e);
            }
        }
        return this.constructor;
    }

    @Override
    public boolean exists() {
        if (this.constructor == null) {
            try {
                this.constructor = this.owner.toClass().getDeclaredConstructor(DynamicClass.resolveAll(this.parameters));
                this.constructor.trySetAccessible();
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public T newInstance(Object ... params) {
        try {
            return this.toConstructor().newInstance(params);
        }
        catch (InstantiationException e) {
            Assertions.fail((String)("Objekt der Klasse " + this.owner + " konnte nicht erzeugt werden, ist die Klasse abstract?"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Assertions.fail((String)("Objekt der Klasse " + this.owner + " konnte nicht erzeugt werden, Zugriff auf Konstruktor nicht m\u00f6glich"), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Assertions.fail((String)("Konstruktor " + this + " konnte Parametertypen " + DynamicMethod.descArgs(params) + " nicht entgegennehmen"), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw UnexpectedExceptionError.wrap(e.getTargetException());
        }
        return null;
    }

    public String toString() {
        return this.owner.toString() + DynamicMethod.descParams(this.parameters);
    }

    @Override
    public void check(Check ... checks) {
        this.toConstructor();
        int modifiers = this.toConstructor().getModifiers();
        String desc = "Konstruktor " + this;
        for (Check check : checks) {
            check.checkModifiers(modifiers, desc);
        }
    }
}

