/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.dynamic;

import java.lang.reflect.Modifier;
import org.apiguardian.api.API;
import org.junit.jupiter.api.Assertions;

@API(status=API.Status.EXPERIMENTAL)
public enum Check {
    STATIC{

        @Override
        void checkModifiers(int modifiers, String desc) {
            if (!Modifier.isStatic(modifiers)) {
                Assertions.fail((String)(desc + " ist nicht statisch."));
            }
        }
    }
    ,
    NOT_STATIC{

        @Override
        void checkModifiers(int modifiers, String desc) {
            if (Modifier.isStatic(modifiers)) {
                Assertions.fail((String)(desc + " ist statisch."));
            }
        }
    }
    ,
    FINAL{

        @Override
        void checkModifiers(int modifiers, String desc) {
            if (!Modifier.isFinal(modifiers)) {
                Assertions.fail((String)(desc + " ist nicht final."));
            }
        }
    }
    ,
    NOT_FINAL{

        @Override
        void checkModifiers(int modifiers, String desc) {
            if (Modifier.isFinal(modifiers)) {
                Assertions.fail((String)(desc + " ist final."));
            }
        }
    }
    ,
    PUBLIC{

        @Override
        void checkModifiers(int modifiers, String desc) {
            if (!Modifier.isPublic(modifiers)) {
                Assertions.fail((String)(desc + " ist nicht public."));
            }
        }
    }
    ,
    NOT_PUBLIC{

        @Override
        void checkModifiers(int modifiers, String desc) {
            if (Modifier.isPublic(modifiers)) {
                Assertions.fail((String)(desc + " ist public."));
            }
        }
    }
    ,
    PACKAGE_PRIVATE{

        @Override
        void checkModifiers(int modifiers, String desc) {
            if (Modifier.isPublic(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers)) {
                Assertions.fail((String)(desc + " ist nicht package-private."));
            }
        }
    };


    abstract void checkModifiers(int var1, String var2);
}

