/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@API(status=API.Status.INTERNAL)
public class ProjectSourcesFinder {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectSourcesFinder.class);
    private static final Pattern GRADLE_SOURCE_DIR_PATTERN = Pattern.compile("def\\s+assignmentSrcDir\\s*=\\s*\"(?<dir>.+)\"");
    private static String pomXmlPath = "pom.xml";
    private static String buildGradlePath = "build.gradle";

    public static Optional<Path> findProjectSourcesPath() {
        String assignmentFolderName = null;
        if (ProjectSourcesFinder.isMavenProject()) {
            assignmentFolderName = ProjectSourcesFinder.getAssignmentFolderNameForMavenProject();
        } else if (ProjectSourcesFinder.isGradleProject()) {
            assignmentFolderName = ProjectSourcesFinder.getAssignmentFolderNameForGradleProject();
        } else {
            LOG.error("Could not find any build file. Contact your instructor.");
        }
        return Optional.ofNullable(assignmentFolderName).map(x$0 -> Path.of(x$0, new String[0]));
    }

    public static boolean isMavenProject() {
        if (pomXmlPath == null) {
            return false;
        }
        File projectFile = new File(pomXmlPath);
        return projectFile.exists() && !projectFile.isDirectory();
    }

    public static boolean isGradleProject() {
        if (buildGradlePath == null) {
            return false;
        }
        File projectFile = new File(buildGradlePath);
        return projectFile.exists() && !projectFile.isDirectory();
    }

    private static String getAssignmentFolderNameForMavenProject() {
        try {
            File pomFile = new File(pomXmlPath);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document pomXmlDocument = documentBuilder.parse(pomFile);
            NodeList buildNodes = pomXmlDocument.getElementsByTagName("build");
            for (int i = 0; i < buildNodes.getLength(); ++i) {
                Node buildNode = buildNodes.item(i);
                if (buildNode.getNodeType() != 1) continue;
                Element buildNodeElement = (Element)buildNode;
                String sourceDirectoryPropertyValue = buildNodeElement.getElementsByTagName("sourceDirectory").item(0).getTextContent();
                return sourceDirectoryPropertyValue.substring(sourceDirectoryPropertyValue.indexOf("}") + 2);
            }
        }
        catch (IOException | NullPointerException | ParserConfigurationException | SAXException e) {
            LOG.error("Could not retrieve the source directory from the pom.xml file. Contact your instructor.", (Throwable)e);
        }
        return null;
    }

    private static String getAssignmentFolderNameForGradleProject() {
        try {
            Path path = Path.of(buildGradlePath, new String[0]);
            String fileContent = Files.readString(path);
            Matcher matcher = GRADLE_SOURCE_DIR_PATTERN.matcher(fileContent);
            if (matcher.find()) {
                return matcher.group("dir");
            }
            return null;
        }
        catch (IOException | NullPointerException e) {
            LOG.error("Could not retrieve the source directory from the build.gradle file. Contact your instructor.", (Throwable)e);
            return null;
        }
    }

    public static String getPomXmlPath() {
        return pomXmlPath;
    }

    public static void setPomXmlPath(String path) {
        pomXmlPath = path;
    }

    public static String getBuildGradlePath() {
        return buildGradlePath;
    }

    public static void setBuildGradlePath(String path) {
        buildGradlePath = path;
    }
}

