/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class LruCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final int maxCacheSize;

    public LruCache(int maxCacheSize) {
        super(maxCacheSize + 1, 0.75f, true);
        this.maxCacheSize = maxCacheSize;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxCacheSize;
    }
}

