/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.io.InputTester;
import de.tum.in.test.api.io.Line;
import de.tum.in.test.api.io.OutputTester;
import de.tum.in.test.api.io.TestInStream;
import de.tum.in.test.api.io.TestOutStream;
import de.tum.in.test.api.localization.Messages;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class IOTester {
    static final String LINE_SEPERATOR = "\n";
    private static IOTester instance;
    private final InputStream oldIn = System.in;
    private final PrintStream oldOut = System.out;
    private final PrintStream oldErr = System.err;
    private final TestInStream in;
    private final TestOutStream out;
    private final TestOutStream err;
    private final InputTester inTester = new InputTester();
    private final OutputTester outTester = new OutputTester();
    private final OutputTester errTester = new OutputTester();
    private boolean isInstalled;

    private IOTester(boolean mirrorOutput, long maxChars) {
        this.in = new TestInStream(this.inTester);
        this.out = new TestOutStream(this.outTester, mirrorOutput ? this.oldOut : null, maxChars);
        this.err = new TestOutStream(this.errTester, mirrorOutput ? this.oldErr : null, maxChars);
    }

    public synchronized void install() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        System.setIn(this.in);
        System.setOut(new PrintStream(this.out, true));
        System.setErr(new PrintStream(this.err, true));
        this.isInstalled = true;
    }

    public synchronized void uninstall() {
        System.setIn(this.oldIn);
        System.setOut(this.oldOut);
        System.setErr(this.oldErr);
        this.isInstalled = false;
    }

    public synchronized void reset() {
        this.inTester.resetInput();
        this.outTester.resetOutput();
        this.errTester.resetOutput();
        this.in.resetInternalState();
        this.out.resetInternalState();
        this.err.resetInternalState();
    }

    public IOTester provideInputLines(String ... givenInputLines) {
        this.inTester.addLinesToInput(givenInputLines);
        return this;
    }

    @Deprecated(since="1.3.2")
    public List<Line> getOutput() {
        return this.outTester.getOutput();
    }

    @Deprecated(since="1.3.2")
    public List<Line> getErrorOutput() {
        return this.errTester.getOutput();
    }

    @Deprecated(since="1.3.2")
    public String getOutputAsString() {
        return Line.joinLinesToString(this.getOutput(), LINE_SEPERATOR);
    }

    @Deprecated(since="1.3.2")
    public String getErrorOutputAsString() {
        return Line.joinLinesToString(this.getErrorOutput(), LINE_SEPERATOR);
    }

    public InputTester getInTester() {
        return this.inTester;
    }

    public OutputTester getOutTester() {
        return this.outTester;
    }

    public OutputTester getErrTester() {
        return this.errTester;
    }

    public InputTester in() {
        return this.getInTester();
    }

    public OutputTester out() {
        return this.getOutTester();
    }

    public OutputTester err() {
        return this.getErrTester();
    }

    public static synchronized boolean isInstalled() {
        return instance != null && IOTester.instance.isInstalled;
    }

    public static synchronized IOTester installNew(boolean mirrorOutput, long maxChars) {
        if (IOTester.isInstalled()) {
            throw new IllegalStateException(Messages.localized("io_tester.already_installed", new Object[0]));
        }
        instance = new IOTester(mirrorOutput, maxChars);
        instance.install();
        return instance;
    }

    public static synchronized void uninstallCurrent() {
        if (!IOTester.isInstalled()) {
            throw new IllegalStateException(Messages.localized("io_tester.not_installed", new Object[0]));
        }
        instance.uninstall();
        instance = null;
    }

    private static void checkEncoding() {
        Charset cs = Charset.defaultCharset();
        if (!"UTF-8".equals(cs.name())) {
            String message = Messages.localized("io_tester.default_not_utf8", cs);
            System.err.println(message);
            throw new IllegalStateException(message);
        }
    }

    static {
        IOTester.checkEncoding();
    }
}

