/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.dynamic;

import de.tum.in.test.api.localization.Messages;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;
import org.apiguardian.api.API;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@API(status=API.Status.MAINTAINED)
public enum Check {
    STATIC{

        @Override
        void checkModifiers(int modifiers, Supplier<String> desc) {
            if (!Modifier.isStatic(modifiers)) {
                throw Messages.localizedFailure("dynamics.check.not_static", desc.get());
            }
        }
    }
    ,
    NOT_STATIC{

        @Override
        void checkModifiers(int modifiers, Supplier<String> desc) {
            if (Modifier.isStatic(modifiers)) {
                throw Messages.localizedFailure("dynamics.check.static", desc.get());
            }
        }
    }
    ,
    FINAL{

        @Override
        void checkModifiers(int modifiers, Supplier<String> desc) {
            if (!Modifier.isFinal(modifiers)) {
                throw Messages.localizedFailure("dynamics.check.not_final", desc.get());
            }
        }
    }
    ,
    NOT_FINAL{

        @Override
        void checkModifiers(int modifiers, Supplier<String> desc) {
            if (Modifier.isFinal(modifiers)) {
                throw Messages.localizedFailure("dynamics.check.final", desc.get());
            }
        }
    }
    ,
    PUBLIC{

        @Override
        void checkModifiers(int modifiers, Supplier<String> desc) {
            if (!Modifier.isPublic(modifiers)) {
                throw Messages.localizedFailure("dynamics.check.not_public", desc.get());
            }
        }
    }
    ,
    NOT_PUBLIC{

        @Override
        void checkModifiers(int modifiers, Supplier<String> desc) {
            if (Modifier.isPublic(modifiers)) {
                throw Messages.localizedFailure("dynamics.check.public", desc.get());
            }
        }
    }
    ,
    PACKAGE_PRIVATE{

        @Override
        void checkModifiers(int modifiers, Supplier<String> desc) {
            if (Modifier.isPublic(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers)) {
                throw Messages.localizedFailure("dynamics.check.not_package", desc.get());
            }
        }
    };


    abstract void checkModifiers(int var1, Supplier<String> var2);
}

