/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.ast.model;

import com.github.javaparser.ast.Node;
import de.tum.in.test.api.ast.model.JavaFile;
import de.tum.in.test.api.ast.model.NodePosition;
import de.tum.in.test.api.localization.Messages;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class UnwantedNode {
    private final String unwantedNodeName;
    private final List<NodePosition> unwantedNodePositions;

    public UnwantedNode(JavaFile javaFile, String unwantedNodeName, Class<? extends Node> nodeDefinedAsUnwanted) {
        this.unwantedNodeName = unwantedNodeName;
        this.unwantedNodePositions = javaFile.getJavaFileAST().findAll(nodeDefinedAsUnwanted).stream().map(NodePosition::getPositionOf).collect(Collectors.toList());
        this.unwantedNodePositions.sort(NodePosition::compareTo);
    }

    public String getUnwantedNodeName() {
        return this.unwantedNodeName;
    }

    public List<NodePosition> getUnwantedNodePositions() {
        return this.unwantedNodePositions;
    }

    public static List<UnwantedNode> getUnwantedNodesInJavaFile(JavaFile javaFile, Map<String, Class<? extends Node>> nodesDefinedAsUnwanted) {
        return nodesDefinedAsUnwanted.keySet().stream().map(unwantedNodeName -> new UnwantedNode(javaFile, (String)unwantedNodeName, (Class)nodesDefinedAsUnwanted.get(unwantedNodeName))).filter(unwantedNode -> !unwantedNode.getUnwantedNodePositions().isEmpty()).sorted(Comparator.comparing(uwn -> uwn.getUnwantedNodePositions().get(0))).collect(Collectors.toList());
    }

    public static Map<Path, List<UnwantedNode>> getUnwantedNodesForFileAt(Path pathOfJavaFile, Map<String, Class<? extends Node>> nodesDefinedAsUnwanted) {
        JavaFile javaFile = JavaFile.convertFromFile(pathOfJavaFile);
        if (javaFile == null) {
            return Map.of();
        }
        List<UnwantedNode> unwantedNodes = UnwantedNode.getUnwantedNodesInJavaFile(javaFile, nodesDefinedAsUnwanted);
        if (unwantedNodes.isEmpty()) {
            return Map.of();
        }
        return Map.of(pathOfJavaFile, unwantedNodes);
    }

    public static String getFormattedPositionString(String positionString) {
        return "   - " + positionString;
    }

    public static String getFormattedUnwantedNodeString(UnwantedNode unwantedNode) {
        return unwantedNode.getUnwantedNodePositions().stream().map(String::valueOf).map(UnwantedNode::getFormattedPositionString).collect(Collectors.joining(System.lineSeparator(), Messages.localized("ast.method.get_formatted_unwanted_node_string_prefix", unwantedNode.getUnwantedNodeName()) + System.lineSeparator(), ""));
    }

    public static String getFormattedFileString(Path filePath, Map<Path, List<UnwantedNode>> unwantedNodes) {
        return unwantedNodes.get(filePath).stream().map(UnwantedNode::getFormattedUnwantedNodeString).collect(Collectors.joining(System.lineSeparator(), Messages.localized("ast.method.get_formatted_file_string_prefix", filePath) + System.lineSeparator(), ""));
    }

    public static Optional<String> getMessageForUnwantedNodesForFileAt(Path pathOfJavaFile, Map<String, Class<? extends Node>> nodeNameUnwantedNodeMap) {
        Map<Path, List<UnwantedNode>> unwantedNodes = UnwantedNode.getUnwantedNodesForFileAt(pathOfJavaFile, nodeNameUnwantedNodeMap);
        if (unwantedNodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(unwantedNodes.keySet().stream().map(filePath -> UnwantedNode.getFormattedFileString(filePath, unwantedNodes)).reduce(String::concat).orElse(""));
    }

    public static Optional<String> getMessageForUnwantedNodesForAllFilesBelow(Path pathOfDirectory, Map<String, Class<? extends Node>> nodeNameUnwantedNodeMap) {
        return JavaFile.readFromDirectory(pathOfDirectory).stream().sorted(Comparator.comparing(JavaFile::getJavaFilePath)).map(javaFile -> UnwantedNode.getMessageForUnwantedNodesForFileAt(javaFile.getJavaFilePath(), nodeNameUnwantedNodeMap)).filter(Optional::isPresent).map(Optional::get).map(message -> message + System.lineSeparator()).reduce(String::concat).map(String::trim).map(message -> " " + message);
    }
}

